/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/configurable-sasl-server-factory=*")
@ResourceType(value="configurable-sasl-server-factory")
public class ConfigurableSASLServerFactory<T extends ConfigurableSASLServerFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The SASL mechanisms available from this factory after all filtering has been applied.")
    private List<String> availableMechanisms;
    @AttributeDocumentation(value="List of filters to be evaluated sequentially combining the results using 'or'.")
    private List<Map> filters;
    @AttributeDocumentation(value="Custom properties to be passed in to the sasl server factory calls.")
    private Map properties;
    @AttributeDocumentation(value="The protocol that should be passed into factory when creating the mechanism.")
    private String protocol;
    @AttributeDocumentation(value="The sasl server factory to be wrapped.")
    private String saslServerFactory;
    @AttributeDocumentation(value="The server name that should be passed into factory when creating the mechanism.")
    private String serverName;

    public ConfigurableSASLServerFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="available-mechanisms")
    public List<String> availableMechanisms() {
        return this.availableMechanisms;
    }

    public T availableMechanisms(List<String> value) {
        List<String> oldValue = this.availableMechanisms;
        this.availableMechanisms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
        }
        return (T)this;
    }

    public T availableMechanism(String value) {
        if (this.availableMechanisms == null) {
            this.availableMechanisms = new ArrayList<String>();
        }
        this.availableMechanisms.add(value);
        return (T)this;
    }

    public T availableMechanisms(String ... args) {
        this.availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filters")
    public List<Map> filters() {
        return this.filters;
    }

    public T filters(List<Map> value) {
        List<Map> oldValue = this.filters;
        this.filters = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filters", oldValue, value);
        }
        return (T)this;
    }

    public T filter(Map value) {
        if (this.filters == null) {
            this.filters = new ArrayList<Map>();
        }
        this.filters.add(value);
        return (T)this;
    }

    public T filters(Map ... args) {
        this.filters(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol")
    public String protocol() {
        return this.protocol;
    }

    public T protocol(String value) {
        String oldValue = this.protocol;
        this.protocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-server-factory")
    public String saslServerFactory() {
        return this.saslServerFactory;
    }

    public T saslServerFactory(String value) {
        String oldValue = this.saslServerFactory;
        this.saslServerFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslServerFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        String oldValue = this.serverName;
        this.serverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverName", oldValue, value);
        }
        return (T)this;
    }
}

