/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3.remoting_profile;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptions;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptionsConsumer;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptionsSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=ejb3/remoting-profile=*/remoting-ejb-receiver=*")
@ResourceType(value="remoting-ejb-receiver")
public class RemotingEJBReceiver<T extends RemotingEJBReceiver<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private RemotingEJBReceiverResources subresources = new RemotingEJBReceiverResources();
    @AttributeDocumentation(value="Remoting ejb receiver connect timeout")
    private Long connectTimeout;
    @AttributeDocumentation(value="Name of outbound connection that will be used by the ejb receiver")
    private String outboundConnectionRef;

    public RemotingEJBReceiver(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RemotingEJBReceiverResources subresources() {
        return this.subresources;
    }

    public T channelCreationOptions(List<ChannelCreationOptions> value) {
        this.subresources.channelCreationOptions = value;
        return (T)this;
    }

    public T channelCreationOptions(ChannelCreationOptions value) {
        this.subresources.channelCreationOptions.add(value);
        return (T)this;
    }

    public T channelCreationOptions(String childKey, ChannelCreationOptionsConsumer consumer) {
        ChannelCreationOptions child = new ChannelCreationOptions(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.channelCreationOptions(child);
        return (T)this;
    }

    public T channelCreationOptions(String childKey) {
        this.channelCreationOptions(childKey, null);
        return (T)this;
    }

    public T channelCreationOptions(ChannelCreationOptionsSupplier supplier) {
        this.channelCreationOptions(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connect-timeout")
    public Long connectTimeout() {
        return this.connectTimeout;
    }

    public T connectTimeout(Long value) {
        Long oldValue = this.connectTimeout;
        this.connectTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outbound-connection-ref")
    public String outboundConnectionRef() {
        return this.outboundConnectionRef;
    }

    public T outboundConnectionRef(String value) {
        String oldValue = this.outboundConnectionRef;
        this.outboundConnectionRef = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outboundConnectionRef", oldValue, value);
        }
        return (T)this;
    }

    public static class RemotingEJBReceiverResources {
        @ResourceDocumentation(value="The options that will be used during the EJB remote channel creation")
        @SubresourceInfo(value="channelCreationOptions")
        private List<ChannelCreationOptions> channelCreationOptions = new ArrayList<ChannelCreationOptions>();

        @Subresource
        public List<ChannelCreationOptions> channelCreationOptions() {
            return this.channelCreationOptions;
        }

        public ChannelCreationOptions channelCreationOptions(String key) {
            return this.channelCreationOptions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

