/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.batch.jberet;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=batch-jberet/thread-factory=*")
@ResourceType(value="thread-factory")
public class ThreadFactory<T extends ThreadFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Specifies the name of a  thread group to create for this thread factory.")
    private String groupName;
    @AttributeDocumentation(value="The name of the created thread factory.")
    private String name;
    @AttributeDocumentation(value="May be used to specify the thread priority of created threads.")
    private Integer priority;
    @AttributeDocumentation(value="The template used to create names for threads.  The following patterns may be used:\n\t%% - emit a percent sign\n\t%t - emit the per-factory thread sequence number\n\t%g - emit the global thread sequence number\n\t%f - emit the factory sequence number\n\t%i - emit the thread ID.")
    private String threadNamePattern;

    public ThreadFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="group-name")
    public String groupName() {
        return this.groupName;
    }

    public T groupName(String value) {
        String oldValue = this.groupName;
        this.groupName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("groupName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="priority")
    public Integer priority() {
        return this.priority;
    }

    public T priority(Integer value) {
        Integer oldValue = this.priority;
        this.priority = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("priority", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-name-pattern")
    public String threadNamePattern() {
        return this.threadNamePattern;
    }

    public T threadNamePattern(String value) {
        String oldValue = this.threadNamePattern;
        this.threadNamePattern = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadNamePattern", oldValue, value);
        }
        return (T)this;
    }
}

