/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.infinispan.CacheContainer;
import org.wildfly.swarm.config.infinispan.CacheContainerConsumer;
import org.wildfly.swarm.config.infinispan.CacheContainerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=infinispan")
@ResourceType(value="subsystem")
@Implicit
public class Infinispan<T extends Infinispan<T>>
implements Keyed {
    private String key = "infinispan";
    private PropertyChangeSupport pcs;
    private InfinispanResources subresources = new InfinispanResources();

    public Infinispan() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public InfinispanResources subresources() {
        return this.subresources;
    }

    public T cacheContainers(List<CacheContainer> value) {
        this.subresources.cacheContainers = value;
        return (T)this;
    }

    public T cacheContainer(CacheContainer value) {
        this.subresources.cacheContainers.add(value);
        return (T)this;
    }

    public T cacheContainer(String childKey, CacheContainerConsumer consumer) {
        CacheContainer child = new CacheContainer(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.cacheContainer(child);
        return (T)this;
    }

    public T cacheContainer(String childKey) {
        this.cacheContainer(childKey, null);
        return (T)this;
    }

    public T cacheContainer(CacheContainerSupplier supplier) {
        this.cacheContainer(supplier.get());
        return (T)this;
    }

    public static class InfinispanResources {
        @ResourceDocumentation(value="The configuration of an infinispan cache container")
        @SubresourceInfo(value="cacheContainer")
        private List<CacheContainer> cacheContainers = new ArrayList<CacheContainer>();

        @Subresource
        public List<CacheContainer> cacheContainers() {
            return this.cacheContainers;
        }

        public CacheContainer cacheContainer(String key) {
            return this.cacheContainers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

