/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.manager;

import java.security.Permission;
import java.util.Arrays;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class StackInspector {
    private static final Permission GET_STACK_INSPECTOR_PERMMISSION = new RuntimePermission("getStackInspector");
    private static final StackInspector INSTANCE = new StackInspector();

    private StackInspector() {
    }

    public static StackInspector getInstance() {
        if (WildFlySecurityManager.isChecking()) {
            System.getSecurityManager().checkPermission(GET_STACK_INSPECTOR_PERMMISSION);
        }
        return INSTANCE;
    }

    public Class<?> getCallerClass(int skipFrames) {
        return WildFlySecurityManager.getCallerClass(Math.max(0, skipFrames) + 2);
    }

    public Class<?>[] getCallStack(int skipFrames, int numFrames) {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        int from = Math.max(0, skipFrames) + 2;
        return Arrays.copyOfRange(stack, from, Math.min(from + numFrames, stack.length));
    }

    public Class<?>[] getCallStack(int skipFrames) {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        int from = Math.max(0, skipFrames) + 2;
        return Arrays.copyOfRange(stack, from, stack.length);
    }

    public Class<?>[] getCallStack() {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        return Arrays.copyOfRange(stack, 2, stack.length);
    }

    public boolean callStackContains(Class<?> clazz) {
        Class<?>[] stack = WildFlySecurityManager.getCallStack();
        for (int i = 2; i < stack.length; ++i) {
            if (stack[i] != clazz) continue;
            return true;
        }
        return false;
    }
}

