/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential._private;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.credential._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    private static final String certificateChainIsEmpty = "ELY01037: Certificate chain is empty";
    private static final String insufficientDataToFormDigestAndSalt = "ELY01053: Insufficient data to form a digest and a salt";
    private static final String invalidSalt2 = "ELY01054: Invalid salt \"%s%s\"";
    private static final String invalidRounds = "ELY01055: Invalid rounds \"%s%s%s%s\"";
    private static final String invalidSalt4 = "ELY01056: Invalid salt \"%s%s%s%s\"";
    private static final String mismatchedPublicPrivateKeyAlgorithms = "ELY01059: Public and private key algorithm names are mismatched";
    private static final String publicKeyIsNull = "ELY01061: Public key is null";
    private static final String privateKeyIsNull = "ELY01063: Private key is null";
    private static final String keySpecMustBeSecretKeySpec = "ELY02032: keySpec must be SecretKeySpect, given: [%s]";
    private static final String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec = "ELY02033: key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]";
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    private static final String invalidKeySpecUnrecognizedKeySpecAlgorithm = "ELY08001: Unrecognized key spec algorithm";
    private static final String invalidKeySpecPasswordSpecCannotBeRenderedAsString = "ELY08002: Password spec cannot be rendered as a string";
    private static final String invalidKeySpecUnknownCryptStringAlgorithm = "ELY08003: Unknown crypt string algorithm";
    private static final String invalidKeySpecInvalidCharacterEncountered = "ELY08004: Invalid character encountered";
    private static final String invalidKeySpecNoIterationCountTerminatorGiven = "ELY08005: No iteration count terminator given";
    private static final String invalidKeySpecUnexpectedEndOfInputString = "ELY08006: Unexpected end of input string";
    private static final String invalidKeySpecNoSaltTerminatorGiven = "ELY08007: No salt terminator given";
    private static final String invalidHashLength = "ELY08008: Invalid hash length";
    private static final String invalidKeySpecUnexpectedEndOfPasswordString = "ELY08009: Unexpected end of password string";
    private static final String invalidKeySpecUnexpectedEndOfPasswordStringWithCause = "ELY08010: Unexpected end of password string";
    private static final String invalidKeySpecInvalidMinorVersion = "ELY08011: Invalid minor version";
    private static final String invalidKeySpecCostMustBeTwoDigitInteger = "ELY08012: Invalid cost: must be a two digit integer";
    private static final String invalidKeySpecNoSuchMessageDigestAlgorithm = "ELY08013: No such MessageDigest algorithm for \"%s\"";
    private static final String invalidKeyNoSuchMessageDigestAlgorithm = "ELY08014: No such MessageDigest algorithm for \"%s\"";
    private static final String invalidKeyCannotVerifyPassword = "ELY08015: Cannot verify password";
    private static final String invalidKeyDesCryptPasswordHashMustBeBytes = "ELY08017: DES crypt password hash must be %d bytes";
    private static final String invalidParameterSpecSaltMustBeBytesBits = "ELY08018: Salt must be %d bytes (%d bits)";
    private static final String invalidNumberOfRoundsMustBeIntBetween = "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    private static final String invalidSaltMustBeBytesLong = "ELY08021: Invalid salt: must be %d bytes long";
    private static final String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes = "ELY08022: BSD DES crypt password hash must be %d bytes";
    private static final String invalidParameterSpecSaltMustBeBytes = "ELY08023: Salt must be %d bytes";
    private static final String invalidKeyBsdDesCryptPasswordHashMustBeBytes = "ELY08024: BSD DES crypt password hash must be %d bytes";
    private static final String invalidKeySpecExpectedSpecGotSpec = "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    private static final String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec = "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    private static final String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm = "ELY08027: Unknown password type or algorithm";
    private static final String noSuchAlgorithmInvalidAlgorithm = "ELY08028: Invalid algorithm \"%s\"";
    private static final String couldNotObtainKeySpecEncodingIdentifier = "ELY08029: Could not obtain key spec encoding identifier.";
    private static final String mismatchedPublicPrivateKeyParameters = "ELY09000: Public and private key parameters are mismatched";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String emptyParameter$str() {
        return emptyParameter;
    }

    @Override
    public final IllegalArgumentException emptyParameter(String parameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParameter$str(), parameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }

    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unrecognizedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateChainIsEmpty$str() {
        return certificateChainIsEmpty;
    }

    @Override
    public final IllegalArgumentException certificateChainIsEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateChainIsEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String insufficientDataToFormDigestAndSalt$str() {
        return insufficientDataToFormDigestAndSalt;
    }

    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.insufficientDataToFormDigestAndSalt$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSalt2$str() {
        return invalidSalt2;
    }

    @Override
    public final IllegalArgumentException invalidSalt(char lo, char hi) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSalt2$str(), Character.valueOf(lo), Character.valueOf(hi)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRounds$str() {
        return invalidRounds;
    }

    @Override
    public final IllegalArgumentException invalidRounds(char b0, char b1, char b2, char b3) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRounds$str(), Character.valueOf(b0), Character.valueOf(b1), Character.valueOf(b2), Character.valueOf(b3)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSalt4$str() {
        return invalidSalt4;
    }

    @Override
    public final IllegalArgumentException invalidSalt(char b0, char b1, char b2, char b3) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSalt4$str(), Character.valueOf(b0), Character.valueOf(b1), Character.valueOf(b2), Character.valueOf(b3)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mismatchedPublicPrivateKeyAlgorithms$str() {
        return mismatchedPublicPrivateKeyAlgorithms;
    }

    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mismatchedPublicPrivateKeyAlgorithms$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String publicKeyIsNull$str() {
        return publicKeyIsNull;
    }

    @Override
    public final IllegalArgumentException publicKeyIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String privateKeyIsNull$str() {
        return privateKeyIsNull;
    }

    @Override
    public final IllegalArgumentException privateKeyIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.privateKeyIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keySpecMustBeSecretKeySpec$str() {
        return keySpecMustBeSecretKeySpec;
    }

    @Override
    public final InvalidKeySpecException keySpecMustBeSecretKeySpec(String type) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.keySpecMustBeSecretKeySpec$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str() {
        return keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec;
    }

    @Override
    public final InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(String keyAndKeySpec) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str(), keyAndKeySpec));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }

    @Override
    public final SaslException mechInvalidOTPAlgorithm(String algorithm) {
        SaslException result = new SaslException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnrecognizedKeySpecAlgorithm$str() {
        return invalidKeySpecUnrecognizedKeySpecAlgorithm;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnrecognizedKeySpecAlgorithm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecPasswordSpecCannotBeRenderedAsString$str() {
        return invalidKeySpecPasswordSpecCannotBeRenderedAsString;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecPasswordSpecCannotBeRenderedAsString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnknownCryptStringAlgorithm$str() {
        return invalidKeySpecUnknownCryptStringAlgorithm;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownCryptStringAlgorithm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecInvalidCharacterEncountered$str() {
        return invalidKeySpecInvalidCharacterEncountered;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecInvalidCharacterEncountered$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecNoIterationCountTerminatorGiven$str() {
        return invalidKeySpecNoIterationCountTerminatorGiven;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoIterationCountTerminatorGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnexpectedEndOfInputString$str() {
        return invalidKeySpecUnexpectedEndOfInputString;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfInputString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecNoSaltTerminatorGiven$str() {
        return invalidKeySpecNoSaltTerminatorGiven;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSaltTerminatorGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidHashLength$str() {
        return invalidHashLength;
    }

    @Override
    public final IllegalArgumentException invalidHashLength() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidHashLength$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnexpectedEndOfPasswordString$str() {
        return invalidKeySpecUnexpectedEndOfPasswordString;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfPasswordString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str() {
        return invalidKeySpecUnexpectedEndOfPasswordStringWithCause;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(Throwable cause) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecInvalidMinorVersion$str() {
        return invalidKeySpecInvalidMinorVersion;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidMinorVersion() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecInvalidMinorVersion$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecCostMustBeTwoDigitInteger$str() {
        return invalidKeySpecCostMustBeTwoDigitInteger;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecCostMustBeTwoDigitInteger$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return invalidKeySpecNoSuchMessageDigestAlgorithm;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return invalidKeyNoSuchMessageDigestAlgorithm;
    }

    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyCannotVerifyPassword$str() {
        return invalidKeyCannotVerifyPassword;
    }

    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(Throwable cause) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyCannotVerifyPassword$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return invalidParameterSpecSaltMustBeBytesBits;
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int bytes, int bits) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return invalidNumberOfRoundsMustBeIntBetween;
    }

    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int min, int max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSaltMustBeBytesLong$str() {
        return invalidSaltMustBeBytesLong;
    }

    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(int length) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSaltMustBeBytesLong$str(), length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeySpecBsdDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return invalidParameterSpecSaltMustBeBytes;
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int bytes) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyBsdDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return invalidKeySpecExpectedSpecGotSpec;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String expected, String got) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return invalidKeyUnknownUnknownPasswordTypeOrAlgorithm;
    }

    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return noSuchAlgorithmInvalidAlgorithm;
    }

    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String algorithm) {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotObtainKeySpecEncodingIdentifier$str() {
        return couldNotObtainKeySpecEncodingIdentifier;
    }

    @Override
    public final IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotObtainKeySpecEncodingIdentifier$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mismatchedPublicPrivateKeyParameters$str() {
        return mismatchedPublicPrivateKeyParameters;
    }

    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyParameters() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mismatchedPublicPrivateKeyParameters$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

