/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.Flag;
import org.wildfly.security.auth.jaspi.impl.AuthenticationModuleDefinition;
import org.wildfly.security.auth.jaspi.impl.ElytronMessageInfo;

class ElytronServerAuthContext
implements ServerAuthContext {
    private final List<AuthModuleWrapper> authModules;
    private boolean initialised = false;
    private Subject serviceSubject;

    ElytronServerAuthContext(List<AuthenticationModuleDefinition> serverAuthModuleDefinitions) {
        ArrayList<AuthModuleWrapper> authModules = new ArrayList<AuthModuleWrapper>(serverAuthModuleDefinitions.size());
        for (AuthenticationModuleDefinition authenticationModuleDefinition : serverAuthModuleDefinitions) {
            authModules.add(new AuthModuleWrapper(authenticationModuleDefinition.getFlag(), authenticationModuleDefinition.getOptions(), authenticationModuleDefinition.getServerAuthModuleFactory().get()));
        }
        this.authModules = authModules;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        AuthStatus finalResult;
        assert (this.initialised) : "Not initialised";
        if (messageInfo instanceof ElytronMessageInfo) {
            ((ElytronMessageInfo)messageInfo).setState(ElytronMessageInfo.State.VALIDATE);
        }
        AuthStatus requiredResult = null;
        AuthStatus optionalResult = null;
        for (AuthModuleWrapper wrapper : this.authModules) {
            ServerAuthModule sam = wrapper.getModule();
            Object originalRequest = messageInfo.getRequestMessage();
            Object originalResponse = messageInfo.getResponseMessage();
            AuthStatus currentResult = sam.validateRequest(messageInfo, clientSubject, serviceSubject);
            if (currentResult == null || currentResult == AuthStatus.FAILURE) {
                throw ElytronMessages.log.invalidAuthStatus(currentResult, sam.getClass().getName());
            }
            if (currentResult != AuthStatus.SUCCESS && (originalRequest != messageInfo.getRequestMessage() || originalResponse != messageInfo.getResponseMessage())) {
                throw ElytronMessages.log.messageWrappedWithoutSuccess(sam.getClass().getName());
            }
            switch (wrapper.getFlag()) {
                case REQUIRED: {
                    if (requiredResult != null && ElytronServerAuthContext.toIndex(currentResult) <= ElytronServerAuthContext.toIndex(requiredResult)) break;
                    requiredResult = currentResult;
                    break;
                }
                case REQUISITE: {
                    if (currentResult != AuthStatus.SUCCESS) {
                        return currentResult;
                    }
                    if (requiredResult != null) break;
                    requiredResult = currentResult;
                    break;
                }
                case SUFFICIENT: {
                    if (currentResult == AuthStatus.SUCCESS) {
                        return requiredResult == null ? currentResult : requiredResult;
                    }
                    if (optionalResult != null && ElytronServerAuthContext.toIndex(currentResult) >= ElytronServerAuthContext.toIndex(optionalResult)) break;
                    optionalResult = currentResult;
                    break;
                }
                case OPTIONAL: {
                    if (optionalResult != null && ElytronServerAuthContext.toIndex(currentResult) >= ElytronServerAuthContext.toIndex(optionalResult)) break;
                    optionalResult = currentResult;
                }
            }
        }
        AuthStatus authStatus = finalResult = requiredResult != null ? requiredResult : optionalResult;
        assert (finalResult != null) : "Resulting AuthStatus can not be null.";
        return finalResult;
    }

    private static int toIndex(AuthStatus authStatus) {
        Assert.checkNotNullParam("authStatus", authStatus);
        if (AuthStatus.SUCCESS == authStatus) {
            return 1;
        }
        if (AuthStatus.SEND_SUCCESS == authStatus) {
            return 2;
        }
        if (AuthStatus.SEND_CONTINUE == authStatus) {
            return 3;
        }
        if (AuthStatus.FAILURE == authStatus) {
            return 4;
        }
        return 5;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        assert (this.initialised) : "Not initialised";
        if (messageInfo instanceof ElytronMessageInfo) {
            ((ElytronMessageInfo)messageInfo).setState(ElytronMessageInfo.State.SECURE);
        }
        AuthStatus result = null;
        for (int i = this.authModules.size() - 1; i >= 0; --i) {
            ServerAuthModule sam = this.authModules.get(i).getModule();
            AuthStatus currentResult = sam.secureResponse(messageInfo, serviceSubject);
            if (currentResult == null || currentResult == AuthStatus.SUCCESS || currentResult == AuthStatus.FAILURE) {
                throw ElytronMessages.log.invalidAuthStatus(currentResult, sam.getClass().getName());
            }
            if (result == null || ElytronServerAuthContext.toIndex(currentResult) > ElytronServerAuthContext.toIndex(result)) {
                result = currentResult;
            }
            if (currentResult == AuthStatus.SEND_FAILURE) break;
        }
        return result;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        assert (this.initialised) : "Not initialised";
        if (messageInfo instanceof ElytronMessageInfo) {
            ((ElytronMessageInfo)messageInfo).setState(ElytronMessageInfo.State.CLEAN);
        }
        for (int i = this.authModules.size() - 1; i > 0; --i) {
            ServerAuthModule sam = this.authModules.get(i).getModule();
            sam.cleanSubject(messageInfo, subject);
        }
    }

    void initialise(Subject serviceSubject, CallbackHandler callbackHandler, Map properties) throws AuthException {
        assert (!this.initialised) : "Already initialised";
        this.serviceSubject = serviceSubject;
        for (AuthModuleWrapper wrapper : this.authModules) {
            ServerAuthModule sam = wrapper.getModule();
            HashMap combined = new HashMap(properties);
            combined.putAll(wrapper.getOptions());
            sam.initialize(null, null, callbackHandler, combined);
        }
        this.initialised = true;
    }

    void testMessageInfo(MessageInfo messageInfo) throws IllegalArgumentException {
        Object requestMessage = messageInfo.getRequestMessage();
        Object responseMessage = messageInfo.getResponseMessage();
        for (AuthModuleWrapper wrapper : this.authModules) {
            ServerAuthModule sam = wrapper.getModule();
            boolean requestAccepted = false;
            boolean responseAccepted = false;
            for (Class acceptedType : sam.getSupportedMessageTypes()) {
                if (acceptedType.isInstance(requestMessage)) {
                    requestAccepted = true;
                }
                if (acceptedType.isInstance(responseMessage)) {
                    responseAccepted = true;
                }
                if (responseAccepted && requestAccepted) break;
            }
            if (!requestAccepted) {
                throw ElytronMessages.log.unsupportedMessageType(requestMessage.getClass().getName(), sam.getClass().getName());
            }
            if (responseAccepted) continue;
            throw ElytronMessages.log.unsupportedMessageType(responseMessage.getClass().getName(), sam.getClass().getName());
        }
    }

    class AuthModuleWrapper {
        private final Flag flag;
        private final Map options;
        private final ServerAuthModule module;

        AuthModuleWrapper(Flag flag, Map options, ServerAuthModule module) {
            this.flag = flag;
            this.options = options;
            this.module = module;
        }

        Flag getFlag() {
            return this.flag;
        }

        Map getOptions() {
            return this.options;
        }

        ServerAuthModule getModule() {
            return this.module;
        }
    }
}

