/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import java.math.BigInteger;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encoder;

public interface ASN1Encodable {
    public void encodeTo(ASN1Encoder var1);

    public static ASN1Encodable ofUtf8String(String string) {
        Assert.checkNotNullParam("string", string);
        return e -> e.encodeUTF8String(string);
    }

    public static ASN1Encodable ofBMPString(String string) {
        Assert.checkNotNullParam("string", string);
        return e -> e.encodeBMPString(string);
    }

    public static ASN1Encodable ofUniversalString(String string) {
        Assert.checkNotNullParam("string", string);
        return e -> e.encodeUniversalString(string);
    }

    public static ASN1Encodable ofIA5String(String string) {
        Assert.checkNotNullParam("string", string);
        return e -> e.encodeIA5String(string);
    }

    public static ASN1Encodable ofPrintableString(String string) {
        Assert.checkNotNullParam("string", string);
        return e -> e.encodePrintableString(string);
    }

    public static ASN1Encodable ofInteger(int value) {
        return e -> e.encodeInteger(value);
    }

    public static ASN1Encodable ofInteger(BigInteger value) {
        Assert.checkNotNullParam("value", value);
        return e -> e.encodeInteger(value);
    }

    public static ASN1Encodable ofOid(String oid) {
        Assert.checkNotNullParam("oid", oid);
        return e -> e.encodeObjectIdentifier(oid);
    }

    public static ASN1Encodable ofEncodedBytes(byte[] bytes) {
        Assert.checkNotNullParam("bytes", bytes);
        return e -> e.writeEncoded(bytes);
    }
}

