/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

class CredentialStoreCommand
extends Command {
    public static int ACTION_NOT_DEFINED = 5;
    public static int ALIAS_NOT_FOUND = 6;
    public static int GENERAL_CONFIGURATION_ERROR = 7;
    public static final String CREDENTIAL_STORE_COMMAND = "credential-store";
    static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    static final String DEFAULT_PICKETBOX_INITIAL_KEY_MATERIAL = "somearbitrarycrazystringthatdoesnotmatter";
    public static final String STORE_LOCATION_PARAM = "location";
    public static final String CONFIGURATION_URI_PARAM = "uri";
    public static final String CREDENTIAL_STORE_PASSWORD_PARAM = "password";
    public static final String CREDENTIAL_STORE_TYPE_PARAM = "type";
    public static final String SALT_PARAM = "salt";
    public static final String ITERATION_PARAM = "iteration";
    public static final String PASSWORD_CREDENTIAL_VALUE_PARAM = "secret";
    public static final String ADD_ALIAS_PARAM = "add";
    public static final String CHECK_ALIAS_PARAM = "exists";
    public static final String ALIASES_PARAM = "aliases";
    public static final String REMOVE_ALIAS_PARAM = "remove";
    public static final String CREATE_CREDENTIAL_STORE_PARAM = "create";
    public static final String HELP_PARAM = "help";
    public static final String PRINT_SUMMARY_PARAM = "summary";
    private final Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;
    private Map<String, String> credentialStoreConfigurationOptions = new HashMap<String, String>();
    private String storageFile = null;

    CredentialStoreCommand() {
        this.options = new Options();
        this.options.addOption("l", STORE_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdLineStoreLocationDesc());
        this.options.addOption("u", CONFIGURATION_URI_PARAM, true, ElytronToolMessages.msg.cmdLineURIDesc());
        this.options.addOption("p", CREDENTIAL_STORE_PASSWORD_PARAM, true, ElytronToolMessages.msg.cmdLineCredentialStorePassword());
        this.options.addOption("s", SALT_PARAM, true, ElytronToolMessages.msg.cmdLineSaltDesc());
        this.options.addOption("i", ITERATION_PARAM, true, ElytronToolMessages.msg.cmdLineIterationCountDesc());
        this.options.addOption("x", PASSWORD_CREDENTIAL_VALUE_PARAM, true, ElytronToolMessages.msg.cmdLinePasswordCredentialValueDesc());
        this.options.addOption("c", CREATE_CREDENTIAL_STORE_PARAM, false, ElytronToolMessages.msg.cmdLineCreateCredentialStoreDesc());
        this.options.addOption("t", CREDENTIAL_STORE_TYPE_PARAM, true, ElytronToolMessages.msg.cmdLineCredentialStoreTypeDesc());
        this.options.addOption("f", PRINT_SUMMARY_PARAM, false, ElytronToolMessages.msg.cmdLinePrintSummary());
        OptionGroup og = new OptionGroup();
        Option a = new Option("a", ADD_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineAddAliasDesc());
        Option e = new Option("e", CHECK_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineCheckAliasDesc());
        Option r = new Option("r", REMOVE_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineRemoveAliasDesc());
        Option v = new Option("v", ALIASES_PARAM, false, ElytronToolMessages.msg.cmdLineAliasesDesc());
        Option h = new Option("h", HELP_PARAM, false, ElytronToolMessages.msg.cmdLineHelp());
        og.addOption(a);
        og.addOption(e);
        og.addOption(r);
        og.addOption(h);
        og.addOption(v);
        og.setRequired(true);
        this.options.addOptionGroup(og);
    }

    @Override
    public void execute(String[] args) throws Exception {
        String alias;
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        this.cmdLine = this.parser.parse(this.options, args, true);
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        }
        String location = this.cmdLine.getOptionValue(STORE_LOCATION_PARAM);
        String uri = this.cmdLine.getOptionValue(CONFIGURATION_URI_PARAM);
        String csPassword = this.cmdLine.getOptionValue(CREDENTIAL_STORE_PASSWORD_PARAM);
        String salt = this.cmdLine.getOptionValue(SALT_PARAM);
        String csType = this.cmdLine.getOptionValue(CREDENTIAL_STORE_TYPE_PARAM, KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE);
        String sIteration = this.cmdLine.getOptionValue(ITERATION_PARAM);
        int iterationCount = -1;
        if (sIteration != null && !sIteration.isEmpty()) {
            try {
                iterationCount = Integer.parseInt(sIteration);
            }
            catch (NumberFormatException e) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw new Exception(e);
            }
        }
        boolean createKeyStore = this.cmdLine.hasOption(CREATE_CREDENTIAL_STORE_PARAM);
        boolean printSummary = this.cmdLine.hasOption(PRINT_SUMMARY_PARAM);
        if (uri != null) {
            this.parse(new URI(uri));
        }
        if (location == null) {
            location = this.storageFile;
        }
        CredentialStore credentialStore = CredentialStore.getInstance(csType);
        this.credentialStoreConfigurationOptions.putIfAbsent(STORE_LOCATION_PARAM, location);
        this.credentialStoreConfigurationOptions.putIfAbsent("modifiable", Boolean.TRUE.toString());
        this.credentialStoreConfigurationOptions.putIfAbsent(CREATE_CREDENTIAL_STORE_PARAM, Boolean.valueOf(createKeyStore).toString());
        this.credentialStoreConfigurationOptions.putIfAbsent("keyStoreType", "JCEKS");
        if (csPassword != null) {
            credentialStore.initialize(this.credentialStoreConfigurationOptions, new CredentialStore.CredentialSourceProtectionParameter(IdentityCredentials.NONE.withCredential(new PasswordCredential(ClearPassword.createRaw("clear", csPassword.toCharArray())))));
        } else {
            credentialStore.initialize(this.credentialStoreConfigurationOptions);
        }
        if (this.cmdLine.hasOption(ADD_ALIAS_PARAM)) {
            alias = this.cmdLine.getOptionValue(ADD_ALIAS_PARAM);
            String secret = this.cmdLine.getOptionValue(PASSWORD_CREDENTIAL_VALUE_PARAM);
            credentialStore.store(alias, this.createCredential(secret));
            credentialStore.flush();
            System.out.println(ElytronToolMessages.msg.aliasStored(alias));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else if (this.cmdLine.hasOption(REMOVE_ALIAS_PARAM)) {
            alias = this.cmdLine.getOptionValue(REMOVE_ALIAS_PARAM);
            credentialStore.remove(alias, PasswordCredential.class);
            credentialStore.flush();
            System.out.println(ElytronToolMessages.msg.aliasRemoved(alias));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else if (this.cmdLine.hasOption(CHECK_ALIAS_PARAM)) {
            alias = this.cmdLine.getOptionValue(CHECK_ALIAS_PARAM);
            if (credentialStore.exists(alias, PasswordCredential.class)) {
                this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
                System.out.println(ElytronToolMessages.msg.aliasExists(alias));
            } else {
                this.setStatus(ALIAS_NOT_FOUND);
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
            }
        } else if (this.cmdLine.hasOption(ALIASES_PARAM)) {
            Set<String> aliases = credentialStore.getAliases();
            StringBuilder list = new StringBuilder();
            for (String alias2 : aliases) {
                list.append(alias2).append(" ");
            }
            System.out.println(ElytronToolMessages.msg.aliases(list.toString()));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else {
            this.setStatus(ACTION_NOT_DEFINED);
            throw ElytronToolMessages.msg.actionToPerformNotDefined();
        }
        if (printSummary) {
            StringBuilder com = new StringBuilder();
            com.append("/subsystem=elytron/credential-store=test:add(uri=\"");
            com.append(uri).append("\"");
            com.append(",relative-to=jboss.server.data.dir,credential-reference={");
            com.append("clear-text=\"");
            if (csPassword != null && !csPassword.startsWith("MASK-") && salt != null && iterationCount > -1) {
                com.append(this.computeMasked(csPassword, salt, iterationCount));
            } else if (csPassword != null) {
                com.append(csPassword);
            }
            com.append("\"})");
            System.out.println(ElytronToolMessages.msg.commandSummary(com.toString()));
        }
    }

    private Credential createCredential(String secret) {
        return new PasswordCredential(ClearPassword.createRaw("clear", secret.toCharArray()));
    }

    private String computeMasked(String secret, String salt, int iteration) throws GeneralSecurityException {
        PasswordBasedEncryptionUtil encryptUtil = new PasswordBasedEncryptionUtil.Builder().alphabet(Alphabet.Base64Alphabet.PICKETBOX_COMPATIBILITY).keyAlgorithm(DEFAULT_ALGORITHM).password(DEFAULT_PICKETBOX_INITIAL_KEY_MATERIAL).salt(salt).iteration(iteration).encryptMode().build();
        StringBuilder sb = new StringBuilder().append("MASK-").append(encryptUtil.encryptAndEncode(secret.toCharArray())).append(";").append(salt).append(";").append(iteration);
        return sb.toString();
    }

    @Override
    protected Set<String> aliases() {
        return Stream.of("cs", "credstore").collect(Collectors.toSet());
    }

    private void parse(URI uri) {
        String path = uri.getPath();
        this.storageFile = path != null && path.length() > 1 ? path.substring(1) : null;
        this.parseQueryParameter(uri.getQuery(), uri.toString());
    }

    private void parseQueryParameter(String query, String uri) {
        if (query == null) {
            return;
        }
        int i = 0;
        boolean state = false;
        StringBuilder token = new StringBuilder();
        String key = null;
        String value = null;
        while (i < query.length()) {
            char c = query.charAt(i);
            if (!state) {
                if (c == '=') {
                    state = true;
                    key = token.toString();
                    value = null;
                    token.setLength(0);
                } else {
                    token.append(c);
                }
                ++i;
                continue;
            }
            if (!state) continue;
            if (c == '\'') {
                if (query.charAt(i - 1) != '=') {
                    throw ElytronToolMessages.msg.credentialStoreURIParameterOpeningQuote(uri);
                }
                int inQuotes = i + 1;
                c = query.charAt(inQuotes);
                while (inQuotes < query.length() && c != '\'') {
                    token.append(c);
                    c = query.charAt(++inQuotes);
                }
                if (c == '\'') {
                    i = inQuotes + 1;
                    if (i >= query.length() || query.charAt(i) == ';') continue;
                    throw ElytronToolMessages.msg.credentialStoreURIParameterClosingQuote(uri);
                }
                throw ElytronToolMessages.msg.credentialStoreURIParameterUnexpectedEnd(uri);
            }
            if (c == ';') {
                value = token.toString();
                if (key == null) {
                    throw ElytronToolMessages.msg.credentialStoreURIParameterNameExpected(uri);
                }
                this.credentialStoreConfigurationOptions.put(key, value);
                ++i;
                key = null;
                value = null;
                token.setLength(0);
                state = false;
                continue;
            }
            token.append(c);
            ++i;
        }
        if (key == null || token.length() <= 0) {
            throw ElytronToolMessages.msg.credentialStoreURIParameterUnexpectedEnd(uri);
        }
        this.credentialStoreConfigurationOptions.put(key, token.toString());
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("java -jar wildfly-elytron-tool.jar credential-store <sub-command> <options>", this.options, true);
    }
}

