/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.Provider;
import java.util.function.Supplier;
import javax.security.sasl.SaslClientFactory;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

public class SetSaslClientFactoryAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final Supplier<SaslClientFactory> saslClientFactorySupplier;

    SetSaslClientFactoryAuthenticationConfiguration(AuthenticationConfiguration parent, Supplier<SaslClientFactory> saslClientFactorySupplier) {
        super(parent);
        this.saslClientFactorySupplier = saslClientFactorySupplier;
    }

    @Override
    SaslClientFactory getSaslClientFactory(Supplier<Provider[]> providers) {
        return this.saslClientFactorySupplier.get();
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetSaslClientFactoryAuthenticationConfiguration(newParent, this.saslClientFactorySupplier);
    }

    @Override
    Supplier<SaslClientFactory> getSaslClientFactorySupplier() {
        return this.saslClientFactorySupplier;
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return this.saslClientFactorySupplier.equals(other.getSaslClientFactorySupplier()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 4733, this.saslClientFactorySupplier.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("SaslClientFactory,");
    }
}

