package org.wildfly.security.sasl._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:55:08+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToResolveMechanismConfiguration(final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToResolveMechanismConfiguration$str());
    }
    private static final String unableToResolveMechanismConfiguration = "ELY01157: Unable to resolve MechanismConfiguration for MechanismInformation";
    protected String unableToResolveMechanismConfiguration$str() {
        return unableToResolveMechanismConfiguration;
    }
    private static final String mechMessageAfterComplete = "ELY05001: Authentication mechanism exchange received a message after authentication was already complete";
    protected String mechMessageAfterComplete$str() {
        return mechMessageAfterComplete;
    }
    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageAfterComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationNotComplete = "ELY05005: Authentication mechanism authentication is not yet complete";
    protected String mechAuthenticationNotComplete$str() {
        return mechAuthenticationNotComplete;
    }
    @Override
    public final IllegalStateException mechAuthenticationNotComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechAuthenticationNotComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorUnexpectedChar = "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    protected String mechSelectorUnexpectedChar$str() {
        return mechSelectorUnexpectedChar;
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(final int codePoint, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorTokenNotAllowed = "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";
    protected String mechSelectorTokenNotAllowed$str() {
        return mechSelectorTokenNotAllowed;
    }
    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(final String token, final long offset, final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorTokenNotAllowed$str(), token, offset, string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechSelectorUnexpectedEnd = "ELY05020: Unexpected end of mechanism selection string \"%s\"";
    protected String mechSelectorUnexpectedEnd$str() {
        return mechSelectorUnexpectedEnd;
    }
    @Override
    public final IllegalArgumentException mechSelectorUnexpectedEnd(final String string) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mechSelectorUnexpectedEnd$str(), string));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechAuthenticationFailed = "ELY05058: Authentication failed";
    protected String mechAuthenticationFailed$str() {
        return mechAuthenticationFailed;
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationFailed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrappingNotConfigured = "ELY05090: Wrapping is not configured";
    protected String wrappingNotConfigured$str() {
        return wrappingNotConfigured;
    }
    @Override
    public final IllegalStateException wrappingNotConfigured() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), wrappingNotConfigured$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonAsciiSpace = "ELY05130: Invalid non-ASCII space \"0x%X\"";
    protected String invalidNonAsciiSpace$str() {
        return invalidNonAsciiSpace;
    }
    @Override
    public final IllegalArgumentException invalidNonAsciiSpace(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonAsciiSpace$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechCallbackHandlerFailedForUnknownReason = "ELY05053: Callback handler failed for unknown reason";
    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return mechCallbackHandlerFailedForUnknownReason;
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerFailedForUnknownReason$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAsciiControl = "ELY05131: Invalid ASCII control \"0x%X\"";
    protected String invalidAsciiControl$str() {
        return invalidAsciiControl;
    }
    @Override
    public final IllegalArgumentException invalidAsciiControl(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAsciiControl$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonAsciiControl = "ELY05132: Invalid non-ASCII control \"0x%X\"";
    protected String invalidNonAsciiControl$str() {
        return invalidNonAsciiControl;
    }
    @Override
    public final IllegalArgumentException invalidNonAsciiControl(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonAsciiControl$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPrivateUseCharacter = "ELY05133: Invalid private use character \"0x%X\"";
    protected String invalidPrivateUseCharacter$str() {
        return invalidPrivateUseCharacter;
    }
    @Override
    public final IllegalArgumentException invalidPrivateUseCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPrivateUseCharacter$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonCharacterCodePoint = "ELY05134: Invalid non-character code point \"0x%X\"";
    protected String invalidNonCharacterCodePoint$str() {
        return invalidNonCharacterCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidNonCharacterCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonCharacterCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogateCodePoint = "ELY05135: Invalid surrogate code point \"0x%X\"";
    protected String invalidSurrogateCodePoint$str() {
        return invalidSurrogateCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidSurrogateCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogateCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPlainTextCodePoint = "ELY05136: Invalid plain text code point \"0x%X\"";
    protected String invalidPlainTextCodePoint$str() {
        return invalidPlainTextCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidPlainTextCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPlainTextCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNonCanonicalCodePoint = "ELY05137: Invalid non-canonical code point \"0x%X\"";
    protected String invalidNonCanonicalCodePoint$str() {
        return invalidNonCanonicalCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidNonCanonicalCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonCanonicalCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidControlCharacter = "ELY05138: Invalid control character \"0x%X\"";
    protected String invalidControlCharacter$str() {
        return invalidControlCharacter;
    }
    @Override
    public final IllegalArgumentException invalidControlCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidControlCharacter$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTaggingCharacter = "ELY05139: Invalid tagging character \"0x%X\"";
    protected String invalidTaggingCharacter$str() {
        return invalidTaggingCharacter;
    }
    @Override
    public final IllegalArgumentException invalidTaggingCharacter(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTaggingCharacter$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unassignedCodePoint = "ELY05140: Unassigned code point \"0x%X\"";
    protected String unassignedCodePoint$str() {
        return unassignedCodePoint;
    }
    @Override
    public final IllegalArgumentException unassignedCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unassignedCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogatePairHightAtEnd = "ELY05141: Invalid surrogate pair (high at end of string) \"0x%X\"";
    protected String invalidSurrogatePairHightAtEnd$str() {
        return invalidSurrogatePairHightAtEnd;
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairHightAtEnd(final char input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogatePairHightAtEnd$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogatePairSecondIsNotLow = "ELY05142: Invalid surrogate pair (second is not low) \"0x%X 0x%X\"";
    protected String invalidSurrogatePairSecondIsNotLow$str() {
        return invalidSurrogatePairSecondIsNotLow;
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairSecondIsNotLow(final char high, final char low) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogatePairSecondIsNotLow$str(), high, low));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSurrogatePairLowWithoutHigh = "ELY05143: Invalid surrogate pair (low without high) \"0x%X\"";
    protected String invalidSurrogatePairLowWithoutHigh$str() {
        return invalidSurrogatePairLowWithoutHigh;
    }
    @Override
    public final IllegalArgumentException invalidSurrogatePairLowWithoutHigh(final char low) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSurrogatePairLowWithoutHigh$str(), low));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCodePoint = "ELY05144: Invalid code point \"0x%X\"";
    protected String invalidCodePoint$str() {
        return invalidCodePoint;
    }
    @Override
    public final IllegalArgumentException invalidCodePoint(final int input) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCodePoint$str(), input));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String disallowedRalDirectionalityInL = "ELY05145: Disallowed R/AL directionality character in L string";
    protected String disallowedRalDirectionalityInL$str() {
        return disallowedRalDirectionalityInL;
    }
    @Override
    public final IllegalArgumentException disallowedRalDirectionalityInL() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), disallowedRalDirectionalityInL$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String disallowedLDirectionalityInRal = "ELY05146: Disallowed L directionality character in R/AL string";
    protected String disallowedLDirectionalityInRal$str() {
        return disallowedLDirectionalityInRal;
    }
    @Override
    public final IllegalArgumentException disallowedLDirectionalityInRal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), disallowedLDirectionalityInRal$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingTrailingRal = "ELY05147: Missing trailing R/AL directionality character";
    protected String missingTrailingRal$str() {
        return missingTrailingRal;
    }
    @Override
    public final IllegalArgumentException missingTrailingRal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingTrailingRal$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEscapeSequence = "ELY05148: Invalid escape sequence";
    protected String invalidEscapeSequence$str() {
        return invalidEscapeSequence;
    }
    @Override
    public final IllegalArgumentException invalidEscapeSequence() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidEscapeSequence$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechServerTimedOut = "ELY05163: Authentication mechanism server timed out";
    protected String mechServerTimedOut$str() {
        return mechServerTimedOut;
    }
    @Override
    public final AuthenticationMechanismException mechServerTimedOut() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
