/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.KeyStoreException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String noRealmFoundInProperties = "ELY01006: No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line";
    private static final String debugJAASAuthenticationFailure = "ELY01007: JAAS authentication failed for principal %s";
    private static final String failedToCreateLoginContext = "ELY01008: Failed to create login context";
    private static final String failedToInstantiateCustomHandler = "ELY01009: Failed to instantiate custom CallbackHandler";
    private static final String fileSystemRealmFailedToOpen = "ELY01012: Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"";
    private static final String fileSystemRealmFailedToRead = "ELY01013: Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"";
    private static final String fileSystemRealmInvalidContent = "ELY01015: Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"";
    private static final String fileSystemRealmMissingAttribute = "ELY01016: Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    private static final String fileSystemRealmInvalidPasswordFormat = "ELY01017: Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    private static final String fileSystemRealmInvalidPasswordAlgorithm = "ELY01018: Filesystem-backed realm encountered invalid password algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    private static final String fileSystemUpdatedFailed = "ELY01020: Filesystem-backed realm failed to update identity \"%s\"";
    private static final String fileSystemRealmDeleteFailed = "ELY01021: Filesystem-backed realm failed to delete identity \"%s\"";
    private static final String fileSystemRealmNotFound = "ELY01022: Filesystem-backed realm failed to find identity \"%s\"";
    private static final String fileSystemRealmFailedToWrite = "ELY01023: Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"";
    private static final String fileSystemRealmAlreadyExists = "ELY01024: Filesystem-backed realm cannot create duplicate identity for identity \"%s\"";
    private static final String fileSystemRealmCertificateReadError = "ELY01025: Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    private static final String fileSystemRealmUnsupportedKeyFormat = "ELY01026: Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    private static final String fileSystemRealmUnsupportedKeyAlgorithm = "ELY01027: Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    private static final String invalidName = "ELY01064: Invalid identity name";
    private static final String fileSystemRealmInvalidOtpDefinition = "ELY01081: Filesystem-backed realm encountered invalid OTP definition in path \"%s\" line %d for identity name \"%s\"";
    private static final String fileSystemRealmInvalidOtpAlgorithm = "ELY01082: Filesystem-backed realm encountered invalid OTP algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"";
    private static final String decodingHashedPasswordFromPropertiesRealmFailed = "ELY01138: Decoding hashed password from users property file failed - should not be set as plain-text property file?";
    private static final String realmCacheUnexpectedType = "ELY01145: Security realm [%s] must implement [%s]";
    private static final String failedToReadKeyStore = "ELY01154: Failed to read key store";
    private static final String invalidUnicodeSequence = "ELY11005: Invalid unicode endoding, offending sequence: %s.";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String noRealmFoundInProperties$str() {
        return noRealmFoundInProperties;
    }

    @Override
    public final RealmUnavailableException noRealmFoundInProperties() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.noRealmFoundInProperties$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void debugJAASAuthenticationFailure(Principal principal, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.debugJAASAuthenticationFailure$str(), (Object)principal);
    }

    protected String debugJAASAuthenticationFailure$str() {
        return debugJAASAuthenticationFailure;
    }

    protected String failedToCreateLoginContext$str() {
        return failedToCreateLoginContext;
    }

    @Override
    public final RealmUnavailableException failedToCreateLoginContext(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.failedToCreateLoginContext$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToInstantiateCustomHandler$str() {
        return failedToInstantiateCustomHandler;
    }

    @Override
    public final RealmUnavailableException failedToInstantiateCustomHandler(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.failedToInstantiateCustomHandler$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmFailedToOpen$str() {
        return fileSystemRealmFailedToOpen;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmFailedToOpen(Path path, String finalName, IOException cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmFailedToOpen$str(), path, finalName), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmFailedToRead$str() {
        return fileSystemRealmFailedToRead;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmFailedToRead(Path path, String finalName, Exception cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmFailedToRead$str(), path, finalName), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmInvalidContent$str() {
        return fileSystemRealmInvalidContent;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidContent(Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidContent$str(), path, lineNumber, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmMissingAttribute$str() {
        return fileSystemRealmMissingAttribute;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmMissingAttribute(String attribute, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmMissingAttribute$str(), attribute, path, lineNumber, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmInvalidPasswordFormat$str() {
        return fileSystemRealmInvalidPasswordFormat;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordFormat(String format, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidPasswordFormat$str(), format, path, lineNumber, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmInvalidPasswordAlgorithm$str() {
        return fileSystemRealmInvalidPasswordAlgorithm;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidPasswordAlgorithm(String algorithm, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidPasswordAlgorithm$str(), algorithm, path, lineNumber, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemUpdatedFailed$str() {
        return fileSystemUpdatedFailed;
    }

    @Override
    public final RealmUnavailableException fileSystemUpdatedFailed(String name, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemUpdatedFailed$str(), name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmDeleteFailed$str() {
        return fileSystemRealmDeleteFailed;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmDeleteFailed(String name, IOException e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmDeleteFailed$str(), name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmNotFound$str() {
        return fileSystemRealmNotFound;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmNotFound(String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmNotFound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmFailedToWrite$str() {
        return fileSystemRealmFailedToWrite;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmFailedToWrite(Path tempPath, String name, Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmFailedToWrite$str(), tempPath, name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmAlreadyExists$str() {
        return fileSystemRealmAlreadyExists;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmAlreadyExists(String name, Throwable e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmAlreadyExists$str(), name), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmCertificateReadError$str() {
        return fileSystemRealmCertificateReadError;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmCertificateReadError(String format, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmCertificateReadError$str(), format, path, lineNumber, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmUnsupportedKeyFormat$str() {
        return fileSystemRealmUnsupportedKeyFormat;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(String format, Path path, int lineNumber, String name) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmUnsupportedKeyFormat$str(), format, path, lineNumber, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmUnsupportedKeyAlgorithm$str() {
        return fileSystemRealmUnsupportedKeyAlgorithm;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(String format, Path path, int lineNumber, String name, Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmUnsupportedKeyAlgorithm$str(), format, path, lineNumber, name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidName$str() {
        return invalidName;
    }

    @Override
    public final IllegalArgumentException invalidName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmInvalidOtpDefinition$str() {
        return fileSystemRealmInvalidOtpDefinition;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpDefinition(Path path, int lineNumber, String name, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidOtpDefinition$str(), path, lineNumber, name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileSystemRealmInvalidOtpAlgorithm$str() {
        return fileSystemRealmInvalidOtpAlgorithm;
    }

    @Override
    public final RealmUnavailableException fileSystemRealmInvalidOtpAlgorithm(String algorithm, Path path, int lineNumber, String name, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.fileSystemRealmInvalidOtpAlgorithm$str(), algorithm, path, lineNumber, name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String decodingHashedPasswordFromPropertiesRealmFailed$str() {
        return decodingHashedPasswordFromPropertiesRealmFailed;
    }

    @Override
    public final RealmUnavailableException decodingHashedPasswordFromPropertiesRealmFailed(Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.decodingHashedPasswordFromPropertiesRealmFailed$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String realmCacheUnexpectedType$str() {
        return realmCacheUnexpectedType;
    }

    @Override
    public final IllegalArgumentException realmCacheUnexpectedType(SecurityRealm realm, Class<? extends CacheableSecurityRealm> expectedType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.realmCacheUnexpectedType$str(), realm, expectedType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToReadKeyStore$str() {
        return failedToReadKeyStore;
    }

    @Override
    public final RealmUnavailableException failedToReadKeyStore(KeyStoreException e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.failedToReadKeyStore$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidUnicodeSequence$str() {
        return invalidUnicodeSequence;
    }

    @Override
    public final IOException invalidUnicodeSequence(String s, NoSuchElementException nsee) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidUnicodeSequence$str(), s), nsee);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

