package org.wildfly.security.password.impl;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import javax.security.sasl.SaslException;
import java.security.InvalidKeyException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-02-24T15:06:39-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String emptyParameter$str() {
        return "ELY00002: Parameter %s is empty";
    }
    @Override
    public final IllegalArgumentException emptyParameter(final String parameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyParameter$str(), parameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unrecognizedAlgorithm$str() {
        return "ELY00004: Unrecognized algorithm \"%s\"";
    }
    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unrecognizedAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPAlgorithm$str() {
        return "ELY05151: Invalid OTP algorithm \"%s\"";
    }
    @Override
    public final SaslException mechInvalidOTPAlgorithm(final String algorithm) {
        final SaslException result = new SaslException(String.format(getLoggingLocale(), mechInvalidOTPAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return "ELY08013: No such MessageDigest algorithm for \"%s\"";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return "ELY08014: No such MessageDigest algorithm for \"%s\"";
    }
    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(final String algorithm) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyCannotVerifyPassword$str() {
        return "ELY08015: Cannot verify password";
    }
    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(final Throwable cause) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyCannotVerifyPassword$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08017: DES crypt password hash must be %d bytes";
    }
    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return "ELY08018: Salt must be %d bytes (%d bits)";
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(final int bytes, final int bits) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    }
    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(final int min, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSaltMustBeBytesLong$str() {
        return "ELY08021: Invalid salt: must be %d bytes long";
    }
    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(final int length) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSaltMustBeBytesLong$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08022: BSD DES crypt password hash must be %d bytes";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return "ELY08023: Salt must be %d bytes";
    }
    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(final int bytes) {
        final InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(getLoggingLocale(), invalidParameterSpecSaltMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08024: BSD DES crypt password hash must be %d bytes";
    }
    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(final int bytes) {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(final String expected, final String got) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return "ELY08026: Unknown algorithm \"%s\" or incompatible PasswordSpec \"%s\"";
    }
    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec(final String algorithm, final String passwordSpec) {
        final InvalidKeySpecException result = new InvalidKeySpecException(String.format(getLoggingLocale(), invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str(), algorithm, passwordSpec));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return "ELY08027: Unknown password type or algorithm";
    }
    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        final InvalidKeyException result = new InvalidKeyException(String.format(getLoggingLocale(), invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return "ELY08028: Invalid algorithm \"%s\"";
    }
    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(final String algorithm) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
