package org.wildfly.security.auth.jaspi._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import javax.security.auth.message.AuthException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import javax.security.auth.message.AuthStatus;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T11:02:16+0000")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unableToConstructProvider = "ELY01167: Unable to construct provider '%s'.";
    protected String unableToConstructProvider$str() {
        return unableToConstructProvider;
    }
    @Override
    public final SecurityException unableToConstructProvider(final String className, final Throwable cause) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unableToConstructProvider$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configAlreadyRegistered = "ELY01168: JASPIC Configuration for messageLayer=%s, and applicationContext=%s already registered.";
    protected String configAlreadyRegistered$str() {
        return configAlreadyRegistered;
    }
    @Override
    public final IllegalStateException configAlreadyRegistered(final String messageLayer, final String applicationContext) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configAlreadyRegistered$str(), messageLayer, applicationContext));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedMessageType = "ELY01169: Message type '%s' is not supported by authentication module '%s'";
    protected String unsupportedMessageType$str() {
        return unsupportedMessageType;
    }
    @Override
    public final IllegalArgumentException unsupportedMessageType(final String messageType, final String authenticationModule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedMessageType$str(), messageType, authenticationModule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unrecognisedAuthContextId = "ELY01170: Unrecognised authContextId '%s'";
    protected String unrecognisedAuthContextId$str() {
        return unrecognisedAuthContextId;
    }
    @Override
    public final AuthException unrecognisedAuthContextId(final String authContextId) {
        final AuthException result = new AuthException(String.format(getLoggingLocale(), unrecognisedAuthContextId$str(), authContextId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMessageType = "ELY01171: Invalid message type '%s', expected '%s'.";
    protected String invalidMessageType$str() {
        return invalidMessageType;
    }
    @Override
    public final IllegalArgumentException invalidMessageType(final String actualMessageType, final String expectedMessageType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMessageType$str(), actualMessageType, expectedMessageType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageDoesNotWrapExistingMessage = "ELY01172: Message does not wrap existing message of type '%s'";
    protected String messageDoesNotWrapExistingMessage$str() {
        return messageDoesNotWrapExistingMessage;
    }
    @Override
    public final IllegalArgumentException messageDoesNotWrapExistingMessage(final String messageType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageDoesNotWrapExistingMessage$str(), messageType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageDoesNotUnWrapExistingMessage = "ELY01173: Message does not un-wrap existing message of type '%s'";
    protected String messageDoesNotUnWrapExistingMessage$str() {
        return messageDoesNotUnWrapExistingMessage;
    }
    @Override
    public final IllegalArgumentException messageDoesNotUnWrapExistingMessage(final String messageType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageDoesNotUnWrapExistingMessage$str(), messageType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageSettingNotAllowed = "ELY01174: Setting message of type '%s' not allowed at this time.";
    protected String messageSettingNotAllowed$str() {
        return messageSettingNotAllowed;
    }
    @Override
    public final IllegalStateException messageSettingNotAllowed(final String messageType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), messageSettingNotAllowed$str(), messageType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageWrappedWithoutSuccess = "ELY01175: The wrapping or request / response messages is only allowed where AuthStatus==SUCCESS ServerAuthenticationModule=%s";
    protected String messageWrappedWithoutSuccess$str() {
        return messageWrappedWithoutSuccess;
    }
    @Override
    public final IllegalStateException messageWrappedWithoutSuccess(final String module) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), messageWrappedWithoutSuccess$str(), module));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAuthStatus = "ELY01176: Invalid AuthStatus %s returned from ServerAuthModule %s.";
    protected String invalidAuthStatus$str() {
        return invalidAuthStatus;
    }
    @Override
    public final IllegalStateException invalidAuthStatus(final AuthStatus authStatus, final String serverAuthModule) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidAuthStatus$str(), authStatus, serverAuthModule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authorizationFailed = "ELY01177: Authorization failed.";
    protected String authorizationFailed$str() {
        return authorizationFailed;
    }
    @Override
    public final IOException authorizationFailed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), authorizationFailed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
