/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.IDToken;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcAccount;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.OidcSecurityContext;
import org.wildfly.security.http.oidc.OidcTokenStore;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;
import org.wildfly.security.http.oidc.RequestAuthenticator;

public class OidcCookieTokenStore
implements OidcTokenStore {
    private final OidcHttpFacade httpFacade;
    private static final String DELIM = "###";
    private static final String LEGACY_DELIM = "___";
    private static final int EXPECTED_NUM_TOKENS = 3;
    private static final int ACCESS_TOKEN_INDEX = 0;
    private static final int ID_TOKEN_INDEX = 1;
    private static final int REFRESH_TOKEN_INDEX = 2;

    public OidcCookieTokenStore(OidcHttpFacade httpFacade) {
        this.httpFacade = httpFacade;
    }

    @Override
    public void checkCurrentToken() {
        OidcClientConfiguration deployment = this.httpFacade.getOidcClientConfiguration();
        OidcPrincipal<RefreshableOidcSecurityContext> principal = OidcCookieTokenStore.getPrincipalFromCookie(deployment, this.httpFacade, this);
        if (principal == null) {
            return;
        }
        RefreshableOidcSecurityContext securityContext = principal.getOidcSecurityContext();
        if (securityContext.isActive() && !securityContext.getOidcClientConfiguration().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = securityContext.refreshToken(false);
        if (success && securityContext.isActive()) {
            return;
        }
        this.saveAccountInfo(new OidcAccount(principal));
    }

    @Override
    public boolean isCached(RequestAuthenticator authenticator) {
        OidcClientConfiguration deployment = this.httpFacade.getOidcClientConfiguration();
        OidcPrincipal<RefreshableOidcSecurityContext> principal = OidcCookieTokenStore.getPrincipalFromCookie(deployment, this.httpFacade, this);
        if (principal == null) {
            ElytronMessages.log.debug("Account was not in cookie or was invalid, returning null");
            return false;
        }
        OidcAccount account = new OidcAccount(principal);
        if (!Oidc.checkCachedAccountMatchesRequest(account, deployment)) {
            return false;
        }
        boolean active = account.checkActive();
        if (!active) {
            active = account.tryRefresh();
        }
        if (active) {
            ElytronMessages.log.debug("Cached account found");
            this.restoreRequest();
            this.httpFacade.authenticationComplete(account, true);
            return true;
        }
        ElytronMessages.log.debug("Account was not active, removing cookie and returning false");
        OidcCookieTokenStore.removeCookie(deployment, this.httpFacade);
        return false;
    }

    @Override
    public void saveAccountInfo(OidcAccount account) {
        RefreshableOidcSecurityContext secContext = account.getOidcSecurityContext();
        OidcCookieTokenStore.setTokenCookie(this.httpFacade.getOidcClientConfiguration(), this.httpFacade, secContext);
        HttpScope exchange = this.httpFacade.getScope(Scope.EXCHANGE);
        exchange.registerForNotification(httpServerScopes -> this.logout());
        exchange.setAttachment(OidcAccount.class.getName(), (Object)account);
        exchange.setAttachment(OidcSecurityContext.class.getName(), (Object)account.getOidcSecurityContext());
        this.restoreRequest();
    }

    @Override
    public void logout() {
        this.logout(false);
    }

    @Override
    public void refreshCallback(RefreshableOidcSecurityContext securityContext) {
        OidcCookieTokenStore.setTokenCookie(this.httpFacade.getOidcClientConfiguration(), this.httpFacade, securityContext);
    }

    @Override
    public void saveRequest() {
    }

    @Override
    public boolean restoreRequest() {
        return false;
    }

    @Override
    public void logout(boolean glo) {
        OidcPrincipal<RefreshableOidcSecurityContext> principal = OidcCookieTokenStore.getPrincipalFromCookie(this.httpFacade.getOidcClientConfiguration(), this.httpFacade, this);
        if (principal == null) {
            return;
        }
        OidcCookieTokenStore.removeCookie(this.httpFacade.getOidcClientConfiguration(), this.httpFacade);
        if (glo) {
            RefreshableOidcSecurityContext securityContext = principal.getOidcSecurityContext();
            if (securityContext == null) {
                return;
            }
            OidcClientConfiguration deployment = this.httpFacade.getOidcClientConfiguration();
            if (!deployment.isBearerOnly() && securityContext instanceof RefreshableOidcSecurityContext) {
                securityContext.logout(deployment);
            }
        }
    }

    @Override
    public void logoutAll() {
    }

    @Override
    public void logoutHttpSessions(List<String> ids) {
    }

    public static void removeCookie(OidcClientConfiguration deployment, OidcHttpFacade facade) {
        String cookiePath = OidcCookieTokenStore.getCookiePath(deployment, facade);
        facade.getResponse().resetCookie("OIDC_STATE", cookiePath);
    }

    public static void setTokenCookie(OidcClientConfiguration deployment, OidcHttpFacade facade, RefreshableOidcSecurityContext session) {
        ElytronMessages.log.debugf("Set new %s cookie now", "OIDC_STATE");
        String accessToken = session.getTokenString();
        String idToken = session.getIDTokenString();
        String refreshToken = session.getRefreshToken();
        String cookie = accessToken + DELIM + idToken + DELIM + refreshToken;
        String cookiePath = OidcCookieTokenStore.getCookiePath(deployment, facade);
        facade.getResponse().setCookie("OIDC_STATE", cookie, cookiePath, null, -1, deployment.getSSLRequired().isRequired(facade.getRequest().getRemoteAddr()), true);
    }

    static String getCookiePath(OidcClientConfiguration deployment, OidcHttpFacade facade) {
        String path;
        String string = path = deployment.getOidcStateCookiePath() == null ? "" : deployment.getOidcStateCookiePath().trim();
        if (path.startsWith("/")) {
            return path;
        }
        String contextPath = OidcCookieTokenStore.getContextPath(facade);
        StringBuilder cookiePath = new StringBuilder(contextPath);
        if (!contextPath.endsWith("/") && !path.isEmpty()) {
            cookiePath.append("/");
        }
        return cookiePath.append(path).toString();
    }

    static String getContextPath(OidcHttpFacade facade) {
        String uri = facade.getRequest().getURI();
        String path = null;
        try {
            path = new URIBuilder(uri).build().getPath();
        }
        catch (URISyntaxException e) {
            throw ElytronMessages.log.invalidUri(uri);
        }
        if (path == null || path.isEmpty()) {
            return "/";
        }
        int index = path.indexOf("/", 1);
        return index == -1 ? path : path.substring(0, index);
    }

    public static OidcPrincipal<RefreshableOidcSecurityContext> getPrincipalFromCookie(OidcClientConfiguration deployment, OidcHttpFacade facade, OidcCookieTokenStore tokenStore) {
        OidcHttpFacade.Cookie cookie = facade.getRequest().getCookie("OIDC_STATE");
        if (cookie == null) {
            ElytronMessages.log.debug("OIDC state cookie not found in current request");
            return null;
        }
        String cookieVal = cookie.getValue();
        String[] tokens = cookieVal.split(DELIM);
        if (tokens.length != 3) {
            tokens = cookieVal.split(LEGACY_DELIM);
        }
        if (tokens.length != 3) {
            ElytronMessages.log.warnf("Invalid format of %s cookie. Count of tokens: %s, expected %s", "OIDC_STATE", tokens.length, 3);
            ElytronMessages.log.debugf("Value of %s cookie is: %s", "OIDC_STATE", cookieVal);
            return null;
        }
        String accessTokenString = tokens[0];
        String idTokenString = tokens[1];
        String refreshTokenString = tokens[2];
        try {
            AccessToken accessToken = new AccessToken(new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build().processToClaims(accessTokenString));
            IDToken idToken = null;
            if (idTokenString != null && idTokenString.length() > 0) {
                idToken = new IDToken(new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build().processToClaims(idTokenString));
            }
            ElytronMessages.log.debug("Token obtained from cookie");
            RefreshableOidcSecurityContext secContext = new RefreshableOidcSecurityContext(deployment, facade.getRequest().getCookie("session_random_value"), tokenStore, accessTokenString, accessToken, idTokenString, idToken, refreshTokenString);
            return new OidcPrincipal<RefreshableOidcSecurityContext>(idToken.getPrincipalName(deployment), secContext);
        }
        catch (InvalidJwtException e) {
            ElytronMessages.log.failedToParseTokenFromCookie(e);
            return null;
        }
    }
}

