/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.wildfly.security.http.oidc.AccessAndIDTokenResponse;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.AuthChallenge;
import org.wildfly.security.http.oidc.AuthenticationError;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.IDToken;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcException;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.OidcTokenStore;
import org.wildfly.security.http.oidc.RequestAuthenticator;
import org.wildfly.security.http.oidc.ServerRequest;
import org.wildfly.security.http.oidc.TokenValidator;

public class OidcRequestAuthenticator {
    protected OidcClientConfiguration deployment;
    protected RequestAuthenticator reqAuthenticator;
    protected int sslRedirectPort;
    protected OidcTokenStore tokenStore;
    protected String tokenString;
    protected String idTokenString;
    protected IDToken idToken;
    protected AccessToken token;
    protected OidcHttpFacade facade;
    protected AuthChallenge challenge;
    protected String refreshToken;
    protected String strippedOauthParametersRequestUri;
    static final boolean ALLOW_QUERY_PARAMS_PROPERTY = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.parseBoolean(System.getProperty("wildfly.elytron.oidc.allow.query.params", "false"));
        }
    });

    public OidcRequestAuthenticator(RequestAuthenticator requestAuthenticator, OidcHttpFacade facade, OidcClientConfiguration deployment, int sslRedirectPort, OidcTokenStore tokenStore) {
        this.reqAuthenticator = requestAuthenticator;
        this.facade = facade;
        this.deployment = deployment;
        this.sslRedirectPort = deployment.getConfidentialPort() != -1 ? deployment.getConfidentialPort() : sslRedirectPort;
        this.tokenStore = tokenStore;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getIDTokenString() {
        return this.idTokenString;
    }

    public void setIDTokenString(String idTokenString) {
        this.idTokenString = idTokenString;
    }

    public IDToken getIDToken() {
        return this.idToken;
    }

    public void setIDToken(IDToken idToken) {
        this.idToken = idToken;
    }

    public String getStrippedOauthParametersRequestUri() {
        return this.strippedOauthParametersRequestUri;
    }

    public void setStrippedOauthParametersRequestUri(String strippedOauthParametersRequestUri) {
        this.strippedOauthParametersRequestUri = strippedOauthParametersRequestUri;
    }

    protected String getRequestUrl() {
        return this.facade.getRequest().getURI();
    }

    protected boolean isRequestSecure() {
        return this.facade.getRequest().isSecure();
    }

    protected OidcHttpFacade.Cookie getCookie(String cookieName) {
        return this.facade.getRequest().getCookie(cookieName);
    }

    protected String getCookieValue(String cookieName) {
        OidcHttpFacade.Cookie cookie = this.getCookie(cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    protected String getError() {
        return Oidc.getQueryParamValue(this.facade, "error");
    }

    protected String getCode() {
        return Oidc.getQueryParamValue(this.facade, "code");
    }

    protected String getRedirectUri(String state) {
        String url = this.getRequestUrl();
        ElytronMessages.log.debugf("callback uri: %s", url);
        try {
            if (!this.facade.getRequest().isSecure() && this.deployment.getSSLRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
                int port = this.getSSLRedirectPort();
                if (port < 0) {
                    return null;
                }
                URIBuilder uriBuilder = new URIBuilder(url).setScheme("https");
                if (port != 443) {
                    uriBuilder.setPort(port);
                }
                url = uriBuilder.build().toString();
            }
            List<String> forwardableQueryParams = Arrays.asList("login_hint", "domain_hint", "kc_idp_hint", "prompt", "max_age", "ui_locales", "scope");
            ArrayList<BasicNameValuePair> forwardedQueryParams = new ArrayList<BasicNameValuePair>(forwardableQueryParams.size());
            HashSet<String> allScopes = new HashSet<String>();
            this.addScopes(this.deployment.getScope(), allScopes);
            for (String paramName : forwardableQueryParams) {
                String paramValue = Oidc.getQueryParamValue(this.facade, paramName);
                if ("scope".equals(paramName)) {
                    paramValue = this.combineAndReorderScopes(allScopes, paramValue);
                }
                if (paramValue != null && !paramValue.isEmpty()) {
                    forwardedQueryParams.add(new BasicNameValuePair(paramName, paramValue));
                }
                url = Oidc.stripQueryParam(url, paramName);
            }
            if (this.deployment.getAuthUrl() == null) {
                return null;
            }
            URIBuilder redirectUriBuilder = new URIBuilder(this.deployment.getAuthUrl()).addParameter("response_type", "code").addParameter("client_id", this.deployment.getResourceName()).addParameter("redirect_uri", this.rewrittenRedirectUri(url)).addParameter("state", state);
            redirectUriBuilder.addParameters(forwardedQueryParams);
            return redirectUriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw ElytronMessages.log.unableToCreateRedirectResponse(e);
        }
    }

    protected int getSSLRedirectPort() {
        return this.sslRedirectPort;
    }

    protected String getStateCode() {
        return Oidc.generateId();
    }

    protected AuthChallenge loginRedirect() {
        final String state = this.getStateCode();
        final String redirect = this.getRedirectUri(state);
        if (redirect == null) {
            return this.challenge(403, AuthenticationError.Reason.NO_REDIRECT_URI, null);
        }
        return new AuthChallenge(){

            @Override
            public int getResponseCode() {
                return 0;
            }

            @Override
            public boolean challenge(OidcHttpFacade exchange) {
                OidcRequestAuthenticator.this.tokenStore.saveRequest();
                ElytronMessages.log.debug("Sending redirect to login page: " + redirect);
                exchange.getResponse().setStatus(302);
                exchange.getResponse().setCookie(OidcRequestAuthenticator.this.deployment.getStateCookieName(), state, "/", null, -1, OidcRequestAuthenticator.this.deployment.getSSLRequired().isRequired(OidcRequestAuthenticator.this.facade.getRequest().getRemoteAddr()), true);
                exchange.getResponse().setHeader("Location", redirect);
                return true;
            }
        };
    }

    protected AuthChallenge checkStateCookie() {
        OidcHttpFacade.Cookie stateCookie = this.getCookie(this.deployment.getStateCookieName());
        if (stateCookie == null) {
            ElytronMessages.log.warn("No state cookie");
            return this.challenge(400, AuthenticationError.Reason.INVALID_STATE_COOKIE, null);
        }
        ElytronMessages.log.debug("** reseting application state cookie");
        this.facade.getResponse().resetCookie(this.deployment.getStateCookieName(), stateCookie.getPath());
        String stateCookieValue = this.getCookieValue(this.deployment.getStateCookieName());
        String state = Oidc.getQueryParamValue(this.facade, "state");
        if (state == null) {
            ElytronMessages.log.warn("state parameter was null");
            return this.challenge(400, AuthenticationError.Reason.INVALID_STATE_COOKIE, null);
        }
        if (!state.equals(stateCookieValue)) {
            ElytronMessages.log.warn("state parameter invalid");
            ElytronMessages.log.warn("cookie: " + stateCookieValue);
            ElytronMessages.log.warn("queryParam: " + state);
            return this.challenge(400, AuthenticationError.Reason.INVALID_STATE_COOKIE, null);
        }
        return null;
    }

    public Oidc.AuthOutcome authenticate() {
        String code = this.getCode();
        if (code == null) {
            ElytronMessages.log.debug("there was no code");
            String error = this.getError();
            if (error != null) {
                ElytronMessages.log.warn("There was an error: " + error);
                this.challenge = this.challenge(400, AuthenticationError.Reason.OAUTH_ERROR, error);
                return Oidc.AuthOutcome.FAILED;
            }
            ElytronMessages.log.debug("redirecting to auth server");
            this.challenge = this.loginRedirect();
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        ElytronMessages.log.debug("there was a code, resolving");
        this.challenge = this.resolveCode(code);
        if (this.challenge != null) {
            return Oidc.AuthOutcome.FAILED;
        }
        return Oidc.AuthOutcome.AUTHENTICATED;
    }

    protected AuthChallenge challenge(final int code, final AuthenticationError.Reason reason, final String description) {
        return new AuthChallenge(){

            @Override
            public int getResponseCode() {
                return code;
            }

            @Override
            public boolean challenge(OidcHttpFacade exchange) {
                AuthenticationError error = new AuthenticationError(reason, description);
                exchange.getRequest().setError(error);
                exchange.getResponse().sendError(code);
                return true;
            }
        };
    }

    protected AuthChallenge resolveCode(String code) {
        AccessAndIDTokenResponse tokenResponse;
        if (!this.isRequestSecure() && this.deployment.getSSLRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            ElytronMessages.log.error("SSL required. Request: " + this.facade.getRequest().getURI());
            return this.challenge(403, AuthenticationError.Reason.SSL_REQUIRED, null);
        }
        ElytronMessages.log.debug("checking state cookie for after code");
        AuthChallenge challenge = this.checkStateCookie();
        if (challenge != null) {
            return challenge;
        }
        this.strippedOauthParametersRequestUri = this.rewrittenRedirectUri(OidcRequestAuthenticator.stripOauthParametersFromRedirect(this.facade.getRequest().getURI()));
        try {
            tokenResponse = ServerRequest.invokeAccessCodeToToken(this.deployment, code, this.strippedOauthParametersRequestUri);
        }
        catch (ServerRequest.HttpFailure failure) {
            ElytronMessages.log.error("failed to turn code into token");
            ElytronMessages.log.error("status from server: " + failure.getStatus());
            if (failure.getError() != null && !failure.getError().trim().isEmpty()) {
                ElytronMessages.log.error("   " + failure.getError());
            }
            return this.challenge(403, AuthenticationError.Reason.CODE_TO_TOKEN_FAILURE, null);
        }
        catch (IOException e) {
            ElytronMessages.log.error("failed to turn code into token", e);
            return this.challenge(403, AuthenticationError.Reason.CODE_TO_TOKEN_FAILURE, null);
        }
        this.tokenString = tokenResponse.getAccessToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIDToken();
        ElytronMessages.log.debug("Verifying tokens");
        Oidc.logToken("\taccess_token", this.tokenString);
        Oidc.logToken("\tid_token", this.idTokenString);
        Oidc.logToken("\trefresh_token", this.refreshToken);
        try {
            TokenValidator tokenValidator = TokenValidator.builder(this.deployment).build();
            TokenValidator.VerifiedTokens verifiedTokens = tokenValidator.parseAndVerifyToken(this.idTokenString, this.tokenString);
            this.idToken = verifiedTokens.getIdToken();
            this.token = verifiedTokens.getAccessToken();
            ElytronMessages.log.debug("Token Verification succeeded!");
        }
        catch (OidcException e) {
            ElytronMessages.log.failedVerificationOfToken(e.getMessage());
            return this.challenge(403, AuthenticationError.Reason.INVALID_TOKEN, null);
        }
        if (tokenResponse.getNotBeforePolicy() > this.deployment.getNotBefore()) {
            this.deployment.updateNotBefore(tokenResponse.getNotBeforePolicy());
        }
        if (this.token.getIssuedAt() < (long)this.deployment.getNotBefore()) {
            ElytronMessages.log.error("Stale token");
            return this.challenge(403, AuthenticationError.Reason.STALE_TOKEN, null);
        }
        ElytronMessages.log.debug("successfully authenticated");
        return null;
    }

    private static String stripOauthParametersFromRedirect(String uri) {
        uri = Oidc.stripQueryParam(uri, "code");
        uri = Oidc.stripQueryParam(uri, "state");
        uri = Oidc.stripQueryParam(uri, "session_state");
        return Oidc.stripQueryParam(uri, "iss");
    }

    private String rewrittenRedirectUri(String originalUri) {
        Map<String, String> rewriteRules = this.deployment.getRedirectRewriteRules();
        if (ALLOW_QUERY_PARAMS_PROPERTY && (rewriteRules == null || rewriteRules.isEmpty())) {
            return originalUri;
        }
        try {
            URL url = new URL(originalUri);
            Map.Entry<String, String> rule = null;
            if (rewriteRules != null && !rewriteRules.isEmpty()) {
                rule = rewriteRules.entrySet().iterator().next();
            }
            StringBuilder redirectUriBuilder = new StringBuilder(url.getProtocol());
            redirectUriBuilder.append("://").append(url.getAuthority());
            if (rule != null) {
                redirectUriBuilder.append(url.getPath().replaceFirst(rule.getKey(), rule.getValue()));
            } else {
                redirectUriBuilder.append(url.getPath());
            }
            return redirectUriBuilder.toString();
        }
        catch (MalformedURLException ex) {
            ElytronMessages.log.error("Not a valid request url");
            throw new RuntimeException(ex);
        }
    }

    private static String addOidcScopeIfNeeded(String scope) {
        if (scope == null || scope.isEmpty()) {
            return "openid";
        }
        if (OidcRequestAuthenticator.hasScope(scope, "openid")) {
            return scope;
        }
        return "openid " + scope;
    }

    private static boolean hasScope(String scopeParam, String targetScope) {
        String[] scopes;
        if (scopeParam == null || targetScope == null) {
            return false;
        }
        for (String scope : scopes = scopeParam.split(" ")) {
            if (!targetScope.equals(scope)) continue;
            return true;
        }
        return false;
    }

    private String combineAndReorderScopes(Set<String> allScopes, String paramValue) {
        StringBuilder combinedScopes = new StringBuilder();
        this.addScopes(paramValue, allScopes);
        combinedScopes.append("openid");
        for (String scope : allScopes) {
            if (scope.equals("openid")) continue;
            combinedScopes.append(" ").append(scope);
        }
        return combinedScopes.toString();
    }

    private void addScopes(String scopes, Set<String> allScopes) {
        if (scopes != null && !scopes.isEmpty()) {
            allScopes.addAll(Arrays.asList(scopes.split("\\s+")));
        }
    }
}

