/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.digest;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.digest.DigestAuthenticationMechanism;
import org.wildfly.security.http.digest.NonceManager;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.provider.util.ProviderUtil;

public class DigestMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final Supplier<Provider[]> providers;
    private static NonceManager nonceManager = new NonceManager(300000L, 900000L, true, 20, "SHA-256", ElytronMessages.httpDigest);

    public DigestMechanismFactory() {
        this.providers = ProviderUtil.INSTALLED_PROVIDERS;
    }

    public DigestMechanismFactory(Provider provider) {
        this(new Provider[]{provider});
    }

    public DigestMechanismFactory(Provider ... providers) {
        this.providers = () -> providers;
    }

    public String[] getMechanismNames(Map<String, ?> properties) {
        ArrayList<String> mechanismNames = new ArrayList<String>();
        mechanismNames.add("DIGEST");
        mechanismNames.add("DIGEST-SHA-256");
        mechanismNames.add("DIGEST-SHA-512-256");
        return mechanismNames.toArray(new String[mechanismNames.size()]);
    }

    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        Assert.checkNotNullParam((String)"properties", properties);
        Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        if (properties.containsKey("nonceManager")) {
            nonceManager = (NonceManager)properties.get("nonceManager");
        }
        switch (mechanismName) {
            case "DIGEST": {
                return new DigestAuthenticationMechanism(callbackHandler, nonceManager, (String)properties.get(HttpConstants.CONFIG_REALM), (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH), "DIGEST", "MD5", this.providers, (String)properties.get(HttpConstants.CONFIG_VALIDATE_DIGEST_URI));
            }
            case "DIGEST-SHA-256": {
                return new DigestAuthenticationMechanism(callbackHandler, nonceManager, (String)properties.get(HttpConstants.CONFIG_REALM), (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH), "DIGEST-SHA-256", "SHA-256", this.providers, (String)properties.get(HttpConstants.CONFIG_VALIDATE_DIGEST_URI));
            }
            case "DIGEST-SHA-512-256": {
                return new DigestAuthenticationMechanism(callbackHandler, nonceManager, (String)properties.get(HttpConstants.CONFIG_REALM), (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH), "DIGEST-SHA-512-256", "SHA-512-256", this.providers, (String)properties.get(HttpConstants.CONFIG_VALIDATE_DIGEST_URI));
            }
        }
        return null;
    }

    public void shutdown() {
        nonceManager.shutdown();
    }
}

