/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.tasks;

import java.util.List;
import javax.ejb.Stateful;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.jboss.as.quickstarts.tasks.Task;
import org.jboss.as.quickstarts.tasks.TaskDao;
import org.jboss.as.quickstarts.tasks.User;

@Stateful
public class TaskDaoImpl
implements TaskDao {
    @Inject
    EntityManager em;

    public void createTask(User user, Task task) {
        if (!this.em.contains((Object)user)) {
            user = (User)this.em.merge((Object)user);
        }
        user.getTasks().add(task);
        task.setOwner(user);
        this.em.persist((Object)task);
    }

    public List<Task> getAll(User user) {
        TypedQuery query = this.querySelectAllTasksFromUser(user);
        return query.getResultList();
    }

    public List<Task> getRange(User user, int offset, int count) {
        TypedQuery query = this.querySelectAllTasksFromUser(user);
        query.setMaxResults(count);
        query.setFirstResult(offset);
        return query.getResultList();
    }

    public List<Task> getForTitle(User user, String title) {
        String lowerCaseTitle = "%" + title.toLowerCase() + "%";
        return this.em.createQuery("SELECT t FROM Task t WHERE t.owner = ?1 AND LOWER(t.title) LIKE ?2", Task.class).setParameter(1, (Object)user).setParameter(2, (Object)lowerCaseTitle).getResultList();
    }

    public void deleteTask(Task task) {
        if (!this.em.contains((Object)task)) {
            task = (Task)this.em.merge((Object)task);
        }
        this.em.remove((Object)task);
    }

    private TypedQuery<Task> querySelectAllTasksFromUser(User user) {
        return this.em.createQuery("SELECT t FROM Task t WHERE t.owner = ?1", Task.class).setParameter(1, (Object)user);
    }
}

