/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.data;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.data.MemberDao;
import org.jboss.as.quickstarts.kitchensink.spring.controlleradvice.model.Member;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class MemberDaoImpl
implements MemberDao {
    @Autowired
    private EntityManager em;

    public Member findById(Long id) {
        return (Member)this.em.find(Member.class, (Object)id);
    }

    public Member findByEmail(String email) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        Root member = criteria.from(Member.class);
        criteria.select((Selection)member).where((Expression)cb.equal((Expression)member.get("email"), (Object)email));
        return (Member)this.em.createQuery(criteria).getSingleResult();
    }

    public List<Member> findAllOrderedByName() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        Root member = criteria.from(Member.class);
        criteria.select((Selection)member).orderBy(new Order[]{cb.asc((Expression)member.get("name"))});
        return this.em.createQuery(criteria).getResultList();
    }

    public void register(Member member) {
        this.em.persist((Object)member);
    }
}

