/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.xa;

import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.quickstarts.xa.XAService;

@WebServlet(value={"/XA"})
public class XAServlet
extends HttpServlet {
    private static String PAGE_HEADER = "<html><head><title>jta-crash-recovery</title></head><body>";
    private static String PAGE_CONTENT = "<h2>XA Recovery</h2><p>This quickstart demonstrates how to atomically update multiple resources within one XA transaction. It updates a relational database table using JPA and sends a message using JMS. In this example, you can perform the following operations:</p><ul><li>To add a <b>key</b>/<b>value</b> pair, enter values in the input text boxes and click <i>Submit</i></li><li>To update a <b>key</b>/<b>value</b> pair, enter the key and click <i>Submit</i></li><li>To delete a <b>key</b>/<b>value</b> pair, enter the key and click <i>Delete</i></li><li>To delete all <b>key</b>/<b>value</b> pairs, leave the key blank and click <i>Delete</i></li><li>To list the existing <b>key</b>/<b>value</b> pairs, leave the key blank and click <i>Submit</i></li><li>The refresh the list, click the <i>Refresh Table</i> link.</li></ul><p>To demonstrate XA recovery, you will take the following steps:</p> <ol><li>Add a <b>key</b>/<b>value</b> as described above.</li><li>Stop the JBoss EAP server.</li><li>Clear any transaction objectstore data remaining from previous tests.</li><li>Configure Byteman to halt the JBoss EAP server.</li><li>Start the JBoss EAP server.</li><li>Add another <b>key</b>/<b>value</b>. This will cause Byteman to halt the JBoss EAP server.</li><li>Verify the database record.</li><li>Disable Byteman.</li><li>Start the JBoss EAP server.</li><li>View the resulting recovered row in the table, indicated by the text \"<i>updated via JMS</i>\".</li></ol></p> <p>See the README file located in the root of <i>jta-crash-rec</i> folder in the quickstart distribution for complete instructions and details about how this quickstart works.</p> <form>Key: <input type=\"text\" name=\"key\" />&nbsp;(Leave blank to list all key/value pairs).<br />Value: <input type=\"text\" name=\"value\" /><br /><input type=\"submit\" name=\"submit\" value=\"Submit\" />&nbsp;Add or update a pair (or list all pairs if key is blank).<br /><input type=\"submit\" name=\"submit\" value=\"Delete\" />&nbsp;Delete a pair (or all pairs if key is blank).<br /></form><p><a href=\".\">Refresh Table</a></p>";
    private static String PAGE_FOOTER = "</body></html>";
    @Inject
    private XAService xaService;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String key = req.getParameter("key");
        String value = req.getParameter("value");
        boolean delete = "Delete".equals(req.getParameter("submit"));
        PrintWriter writer = resp.getWriter();
        String responseText = this.xaService.updateKeyValueDatabase(delete, key, value);
        writer.println(PAGE_HEADER);
        writer.println(PAGE_CONTENT);
        writer.println(responseText);
        writer.println(PAGE_FOOTER);
        writer.close();
    }
}

