/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.cdi.extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.as.quickstart.cdi.extension.XmlBackedWrappedInjectionTarget;
import org.jboss.as.quickstart.cdi.extension.model.Creature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CreatureExtension
implements Extension {
    private final Document document;
    private final Logger log = Logger.getLogger(CreatureExtension.class.getName());

    public CreatureExtension() {
        try {
            InputStream creatureDefs = CreatureExtension.class.getClassLoader().getResourceAsStream("creatures.xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(creatureDefs);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error building xml parser, aborting", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("SAX exception while parsing xml file", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading or parsing xml file", e);
        }
    }

    <X extends Creature> void processInjectionTarget(@Observes ProcessInjectionTarget<X> pit) {
        Class klass = pit.getAnnotatedType().getJavaClass();
        this.log.info("Setting up injection target for " + klass);
        Element entry = (Element)this.document.getElementsByTagName(klass.getSimpleName().toLowerCase()).item(0);
        pit.setInjectionTarget((InjectionTarget)new XmlBackedWrappedInjectionTarget(pit.getInjectionTarget(), entry));
    }
}

