/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.plugin.cli.CliSession;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.provision.AbstractProvisionServerMojo;

@Mojo(name="package", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class PackageServerMojo
extends AbstractProvisionServerMojo {
    @Parameter(alias="extra-server-content-dirs")
    List<String> extraServerContentDirs = Collections.emptyList();
    @Parameter(alias="packaging-scripts")
    private List<CliSession> packagingScripts = new ArrayList<CliSession>();
    @Parameter(property="wildfly.deployment.filename")
    private String filename;
    @Parameter(property="wildfly.serverConfig", alias="server-config", defaultValue="standalone.xml")
    private String serverConfig;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Parameter(property="wildfly.deployment.runtime.name", alias="runtime-name")
    private String runtimeName;
    @Parameter(name="stdout", defaultValue="System.out", property="wildfly.stdout")
    private String stdout;
    @Parameter(defaultValue="false", property="wildfly.package.skip")
    private boolean skip;
    @Inject
    private CommandExecutor commandExecutor;

    @Override
    protected ProvisioningConfig getDefaultConfig() throws ProvisioningDescriptionException {
        return null;
    }

    @Override
    protected String getGoal() {
        return "package";
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping " + this.getGoal() + " of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        super.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serverProvisioned(Path jbossHome) throws MojoExecutionException, MojoFailureException {
        try {
            if (StandardOutput.isFile(this.stdout)) {
                Files.deleteIfExists(Paths.get(this.stdout, new String[0]));
            }
            if (!this.extraServerContentDirs.isEmpty()) {
                this.getLog().info((CharSequence)"Copying extra content to server");
                this.copyExtraContent(jbossHome);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), (Exception)ex);
        }
        Path deploymentContent = this.getDeploymentContent();
        if (Files.exists(deploymentContent, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Deploying " + deploymentContent));
            List<String> deploymentCommands = this.getDeploymentCommands(deploymentContent);
            CommandConfiguration cmdConfigDeployment = CommandConfiguration.of(() -> null, () -> null).addCommands((Collection<String>)deploymentCommands).setJBossHome(jbossHome).addCLIArguments("--echo-command").setFork(true).setAppend(true).setStdout(this.stdout).setOffline(true);
            this.commandExecutor.execute(cmdConfigDeployment, this.artifactResolver);
        }
        try {
            if (!this.packagingScripts.isEmpty()) {
                this.getLog().info((CharSequence)"Excuting CLI commands and scripts");
                for (CliSession session : this.packagingScripts) {
                    List<File> wrappedScripts = this.wrapOfflineScripts(session.getScripts());
                    try {
                        CommandConfiguration cmdConfig = CommandConfiguration.of(() -> null, () -> null).addCommands(this.wrapOfflineCommands(session.getCommands())).addScripts(wrappedScripts).addCLIArguments("--echo-command").setJBossHome(jbossHome).setFork(true).setAppend(true).setStdout(this.stdout).addPropertiesFiles(this.resolveFiles(session.getPropertiesFiles())).addJvmOptions(session.getJavaOpts()).setResolveExpression(session.getResolveExpression()).setOffline(true);
                        this.commandExecutor.execute(cmdConfig, this.artifactResolver);
                    }
                    finally {
                        for (File f : wrappedScripts) {
                            Files.delete(f.toPath());
                        }
                    }
                }
            }
            PackageServerMojo.cleanupServer(jbossHome);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), (Exception)ex);
        }
    }

    private List<File> resolveFiles(List<File> files) {
        if (files == null || files.isEmpty()) {
            return files;
        }
        ArrayList<File> resolvedFiles = new ArrayList<File>();
        for (File f : files) {
            resolvedFiles.add(PackageServerMojo.resolvePath(this.project, f.toPath()).toFile());
        }
        return resolvedFiles;
    }

    private List<String> getDeploymentCommands(Path deploymentContent) throws MojoExecutionException {
        ArrayList<String> deploymentCommands = new ArrayList<String>();
        StringBuilder deploymentBuilder = new StringBuilder();
        deploymentBuilder.append("deploy  ").append(deploymentContent).append(" --name=").append(this.name == null ? deploymentContent.getFileName() : this.name).append(" --runtime-name=").append(this.runtimeName == null ? deploymentContent.getFileName() : this.runtimeName);
        deploymentCommands.add(deploymentBuilder.toString());
        return this.wrapOfflineCommands(deploymentCommands);
    }

    private List<String> wrapOfflineCommands(List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return commands;
        }
        ArrayList<String> offlineCommands = new ArrayList<String>();
        offlineCommands.add("embed-server --server-config=" + this.serverConfig);
        offlineCommands.addAll(commands);
        offlineCommands.add("stop-embedded-server");
        return offlineCommands;
    }

    private List<File> wrapOfflineScripts(List<File> scripts) throws IOException, MojoExecutionException {
        ArrayList<File> wrappedScripts = new ArrayList<File>();
        for (File script : scripts) {
            wrappedScripts.add(this.wrapScript(script).toFile());
        }
        return wrappedScripts;
    }

    private Path wrapScript(File script) throws IOException, MojoExecutionException {
        Path tempScript = Files.createTempFile("offline-cli-script", ".cli", new FileAttribute[0]);
        Path resolvedScript = PackageServerMojo.resolvePath(this.project, script.toPath());
        if (!Files.exists(resolvedScript, new LinkOption[0])) {
            throw new MojoExecutionException("CLI script " + resolvedScript + " doesn't exist");
        }
        List<String> cmds = Files.readAllLines(resolvedScript, StandardCharsets.UTF_8);
        List<String> wrappedCommands = this.wrapOfflineCommands(cmds);
        Files.write(tempScript, wrappedCommands, StandardCharsets.UTF_8, new OpenOption[0]);
        return tempScript;
    }

    public void copyExtraContent(Path target) throws MojoExecutionException, IOException {
        for (String path : this.extraServerContentDirs) {
            Path extraContent = Paths.get(path, new String[0]);
            if (Files.notExists(extraContent = PackageServerMojo.resolvePath(this.project, extraContent), new LinkOption[0])) {
                throw new MojoExecutionException("Extra content dir " + extraContent + " doesn't exist");
            }
            this.warnExtraConfig(extraContent);
            IoUtils.copy((Path)extraContent, (Path)target);
        }
    }

    private void warnExtraConfig(Path extraContentDir) {
        Path config = extraContentDir.resolve("standalone").resolve("configurations").resolve("standalone.xml");
        if (Files.exists(config, new LinkOption[0])) {
            this.getLog().warn((CharSequence)("The file " + config + " overrides the Galleon generated configuration, un-expected behavior can occur when starting the server"));
        }
    }

    private Path getDeploymentContent() {
        PackageType packageType = PackageType.resolve(this.project);
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        return this.targetDir.toPath().resolve(filename);
    }

    private static void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        Path tmp = jbossHome.resolve("standalone").resolve("tmp");
        IoUtils.recursiveDelete((Path)tmp);
        Path log = jbossHome.resolve("standalone").resolve("log");
        IoUtils.recursiveDelete((Path)log);
    }
}

