/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import org.wildfly.plugin.common.ConnectionInfo;
import org.wildfly.plugin.common.Files;

class ServerInfo {
    private final ConnectionInfo connectionInfo;
    private final File jbossHome;
    private final String modulesDir;
    private final String[] jvmArgs;
    private final String javaHome;
    private final String serverConfig;
    private final String propertiesFile;
    private final long startupTimeout;

    private ServerInfo(ConnectionInfo connectionInfo, String javaHome, File jbossHome, String modulesDir, String[] jvmArgs, String serverConfig, String propertiesFile, long startupTimeout) {
        this.connectionInfo = connectionInfo;
        this.javaHome = javaHome;
        this.jbossHome = jbossHome;
        this.modulesDir = modulesDir == null ? Files.createPath(jbossHome.getAbsolutePath(), "modules") : modulesDir;
        this.jvmArgs = jvmArgs;
        this.serverConfig = serverConfig;
        this.propertiesFile = propertiesFile;
        this.startupTimeout = startupTimeout;
    }

    public static ServerInfo of(ConnectionInfo connectionInfo, String javaHome, File jbossHome, String modulesDir, String[] jvmArgs, String serverConfig, String propertiesFile, long startupTimeout) {
        return new ServerInfo(connectionInfo, javaHome, jbossHome, modulesDir, jvmArgs, serverConfig, propertiesFile, startupTimeout);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public File getJbossHome() {
        return this.jbossHome;
    }

    public String getModulesDir() {
        return this.modulesDir;
    }

    public String[] getJvmArgs() {
        return this.jvmArgs;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public long getStartupTimeout() {
        return this.startupTimeout;
    }
}

