/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonArtifactCoordinate;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.plugin.tools.PluginProgressTracker;
import org.wildfly.plugin.tools.bootablejar.BootLoggingConfiguration;
import org.wildfly.plugin.tools.bootablejar.BootableJarSupport;
import org.wildfly.plugin.tools.bootablejar.ScannedArtifacts;
import org.wildfly.plugins.bootablejar.maven.cli.CLIExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.LocalCLIExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.RemoteCLIExecutor;
import org.wildfly.plugins.bootablejar.maven.common.FeaturePack;
import org.wildfly.plugins.bootablejar.maven.common.MavenRepositoriesEnricher;
import org.wildfly.plugins.bootablejar.maven.common.OverriddenArtifact;
import org.wildfly.plugins.bootablejar.maven.common.Utils;
import org.wildfly.plugins.bootablejar.maven.goals.ChannelConfiguration;
import org.wildfly.plugins.bootablejar.maven.goals.ChannelMavenArtifactRepositoryManager;
import org.wildfly.plugins.bootablejar.maven.goals.CliSession;
import org.wildfly.plugins.bootablejar.maven.goals.MavenJBossLogger;
import org.wildfly.plugins.bootablejar.maven.goals.MavenProjectArtifactVersions;
import org.wildfly.plugins.bootablejar.maven.goals.MavenUpgrade;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractBuildBootableJarMojo
extends AbstractMojo {
    public static final String JAR = "jar";
    public static final String WAR = "war";
    public static final String STANDALONE = "standalone";
    public static final String STANDALONE_XML = "standalone.xml";
    private static final String SERVER_CONFIG = "--server-config";
    private static final String MAVEN_REPO_PLUGIN_OPTION = "jboss-maven-repo";
    private static final String JBOSS_MAVEN_DIST = "jboss-maven-dist";
    private static final String JBOSS_PROVISIONING_MAVEN_REPO = "jboss-maven-provisioning-repo";
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String PLUGIN_PROVISIONING_FILE = ".wildfly-jar-plugin-provisioning.xml";
    @Component
    RepositorySystem repoSystem;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(alias="plugin-options", required=false)
    Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="offline", defaultValue="false")
    boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    boolean logTime;
    @Parameter(alias="layers", required=false)
    List<String> layers = Collections.emptyList();
    @Parameter(alias="excluded-layers", required=false)
    List<String> excludedLayers = Collections.emptyList();
    @Parameter(alias="record-state", defaultValue="false")
    boolean recordState;
    @Parameter(defaultValue="${project.build.directory}")
    String projectBuildDir;
    @Parameter(alias="context-root", defaultValue="true", property="wildfly.bootable.context.root")
    boolean contextRoot;
    @Parameter(alias="feature-pack-location", required=false, property="wildfly.bootable.fpl")
    String featurePackLocation;
    @Parameter(alias="cli-sessions")
    List<CliSession> cliSessions = Collections.emptyList();
    @Parameter(alias="hollow-jar", property="wildfly.bootable.hollow")
    boolean hollowJar;
    @Parameter(defaultValue="false", property="wildfly.bootable.package.skip")
    boolean skip;
    @Parameter(alias="output-file-name", property="wildfly.bootable.package.output.file.name")
    String outputFileName;
    @Parameter(alias="feature-packs", required=false)
    List<FeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="extra-server-content-dirs", property="wildfly.bootable.package.extra.server.content.dirs")
    List<String> extraServerContentDirs = Collections.emptyList();
    @Parameter(alias="provisioning-file", property="wildfly.bootable.provisioning.file", defaultValue="${project.basedir}/galleon/provisioning.xml")
    private File provisioningFile;
    @Parameter(alias="display-cli-scripts-output")
    boolean displayCliScriptsOutput;
    @Parameter(alias="boot-logging-config", property="wildfly.bootable.logging.config")
    private File bootLoggingConfig;
    @Parameter(alias="bootable-jar-build-artifacts", property="wildfly.bootable.jar.build.artifacts", defaultValue="bootable-jar-build-artifacts")
    private String bootableJarBuildArtifacts;
    @Deprecated
    @Parameter(alias="overridden-server-artifacts")
    List<OverriddenArtifact> overriddenServerArtifacts = Collections.emptyList();
    @Deprecated
    @Parameter(alias="dump-original-artifacts", property="bootable.jar.dump.original.artifacts", defaultValue="false")
    boolean dumpOriginalArtifacts;
    @Deprecated
    @Parameter(alias="disable-warn-for-artifact-downgrade", property="bootable.jar.disable.warn.for.artifact.downgrade", defaultValue="false")
    boolean disableWarnForArtifactDowngrade;
    @Parameter(alias="install-artifact-classifier", property="bootable.jar.install.artifact.classifier", defaultValue="bootable")
    String installArtifactClassifier;
    @Parameter(alias="channels", property="wildfly.channels")
    List<ChannelConfiguration> channels;
    MavenProjectArtifactVersions artifactVersions;
    private final BootLoggingConfiguration bootLoggingConfiguration = new BootLoggingConfiguration();
    private final List<String> extraLayers = new ArrayList<String>();
    private Path wildflyDir;
    private MavenRepoManager artifactResolver;
    private boolean forkCli;
    private ScannedArtifacts scannedArtifacts;

    public Path getJBossHome() {
        return this.wildflyDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenRepositoriesEnricher.enrich(this.session, this.project, this.repositories);
        if (this.isChannelsProvisioning()) {
            try {
                this.artifactResolver = new ChannelMavenArtifactRepositoryManager(this.channels, this.repoSystem, this.repoSession, this.repositories, this.getLog(), this.offline);
            }
            catch (MalformedURLException | UnresolvedMavenArtifactException ex) {
                throw new MojoExecutionException(ex.getLocalizedMessage(), (Exception)ex);
            }
        } else {
            MavenArtifactRepositoryManager mavenArtifactRepositoryManager = this.artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        }
        if (this.outputFileName == null) {
            this.outputFileName = this.project.getBuild().getFinalName() + "-bootable.jar";
        }
        this.artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
        this.validateProjectFile();
        if (this.isPackageDev()) {
            Path deployments = this.getDeploymentsDir();
            IoUtils.recursiveDelete((Path)deployments);
            try {
                Files.createDirectory(deployments, new FileAttribute[0]);
                this.copyProjectFile(deployments);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Fail creating deployments directory ", (Exception)ex);
            }
            return;
        }
        Path contentRoot = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.bootableJarBuildArtifacts);
        if (Files.exists(contentRoot, new LinkOption[0])) {
            AbstractBuildBootableJarMojo.deleteDir(contentRoot);
        }
        Path jarFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.outputFileName);
        IoUtils.recursiveDelete((Path)contentRoot);
        this.wildflyDir = contentRoot.resolve("wildfly");
        Path contentDir = contentRoot.resolve("jar-content");
        try {
            Files.createDirectories(contentRoot, new FileAttribute[0]);
            Files.createDirectories(contentDir, new FileAttribute[0]);
            Files.deleteIfExists(jarFile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Packaging wildfly failed", (Exception)ex);
        }
        try {
            this.provisionServer(this.wildflyDir, contentDir.resolve("provisioning.xml"), contentRoot);
            if (this.artifactResolver instanceof ChannelMavenArtifactRepositoryManager) {
                ((ChannelMavenArtifactRepositoryManager)this.artifactResolver).done(this.wildflyDir);
            }
        }
        catch (IOException | XMLStreamException | ProvisioningException ex) {
            throw new MojoExecutionException("Provisioning failed", (Exception)ex);
        }
        try {
            this.forkCli = Boolean.parseBoolean(this.pluginOptions.getOrDefault("jboss-fork-embedded", "true"));
            if (this.forkCli) {
                this.getLog().info((CharSequence)"CLI executions are done in forked process");
            }
            this.copyExtraContentInternal(this.wildflyDir, contentDir);
            this.copyExtraContent(this.wildflyDir);
            ArrayList<String> commands = new ArrayList<String>();
            this.deploy(commands);
            ArrayList<String> serverConfigCommands = new ArrayList<String>();
            this.configureCli(serverConfigCommands);
            commands.addAll(serverConfigCommands);
            if (!commands.isEmpty()) {
                this.executeCliScript(this.wildflyDir, commands, null, false, "Server configuration", true);
                if (!serverConfigCommands.isEmpty()) {
                    Path genCliScript = contentRoot.resolve("generated-cli-script.txt");
                    try (BufferedWriter writer = Files.newBufferedWriter(genCliScript, StandardCharsets.UTF_8, new OpenOption[0]);){
                        for (String str : serverConfigCommands) {
                            writer.write(str);
                            writer.newLine();
                        }
                    }
                    this.getLog().info((CharSequence)("Stored CLI script executed to update server configuration in " + genCliScript + " file."));
                }
            }
            this.userScripts(this.wildflyDir, this.cliSessions, true);
            Path loggingFile = this.copyLoggingFile(contentRoot);
            if (this.bootLoggingConfig == null) {
                this.generateLoggingConfig(this.wildflyDir);
            } else {
                Path loggingConfig = this.resolvePath(this.bootLoggingConfig.toPath());
                if (Files.notExists(loggingConfig, new LinkOption[0])) {
                    throw new MojoExecutionException(String.format("The bootLoggingConfig %s does not exist.", loggingConfig));
                }
                Path target = this.getJBossHome().resolve(STANDALONE).resolve("configuration").resolve("logging.properties");
                Files.copy(loggingConfig, target, StandardCopyOption.REPLACE_EXISTING);
            }
            BootableJarSupport.zipServer((Path)this.wildflyDir, (Path)contentDir);
            this.buildJar(contentDir, jarFile);
            this.restoreLoggingFile(loggingFile);
        }
        catch (Exception ex) {
            if (ex instanceof MojoExecutionException) {
                throw (MojoExecutionException)ex;
            }
            if (ex instanceof MojoFailureException) {
                throw (MojoFailureException)ex;
            }
            throw new MojoExecutionException("Packaging wildfly failed", ex);
        }
        finally {
            System.clearProperty("module.path");
        }
        this.attachJar(jarFile);
    }

    private boolean isChannelsProvisioning() {
        return this.channels != null && !this.channels.isEmpty();
    }

    protected boolean isPackageDev() {
        return System.getProperty("dev") != null;
    }

    private Path copyLoggingFile(Path contentRoot) throws IOException {
        Path configDir = this.getJBossHome().resolve(STANDALONE).resolve("configuration");
        Path loggingFile = configDir.resolve("logging.properties");
        Path originalLoggingFile = contentRoot.resolve("logging.properties");
        if (Files.exists(loggingFile, new LinkOption[0])) {
            Files.copy(loggingFile, originalLoggingFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return originalLoggingFile;
    }

    private void restoreLoggingFile(Path originalLoggingFile) throws IOException {
        if (Files.exists(originalLoggingFile, new LinkOption[0])) {
            Path configDir = this.getJBossHome().resolve(STANDALONE).resolve("configuration");
            Path bootableLoggingFile = configDir.resolve("wildfly-jar-generated-logging.properties");
            Path loggingFile = configDir.resolve("logging.properties");
            Files.copy(loggingFile, bootableLoggingFile, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(originalLoggingFile, loggingFile, StandardCopyOption.REPLACE_EXISTING);
            Files.delete(originalLoggingFile);
        }
    }

    private void copyExtraContent(Path wildflyDir) throws Exception {
        for (String path : this.extraServerContentDirs) {
            Path extraContent = Paths.get(path, new String[0]);
            if (Files.notExists(extraContent = this.resolvePath(extraContent), new LinkOption[0])) {
                throw new Exception("Extra content dir " + extraContent + " doesn't exist");
            }
            this.warnExtraConfig(extraContent);
            IoUtils.copy((Path)extraContent, (Path)wildflyDir);
        }
    }

    private void warnExtraConfig(Path extraContentDir) {
        Path config = extraContentDir.resolve(STANDALONE).resolve("configurations").resolve(STANDALONE_XML);
        if (Files.exists(config, new LinkOption[0])) {
            this.getLog().warn((CharSequence)("The file " + config + " overrides the Galleon generated configuration, un-expected behavior can occur when starting the bootable JAR"));
        }
    }

    protected void copyExtraContentInternal(Path wildflyDir, Path contentDir) throws Exception {
    }

    protected boolean updateManifest(Manifest manifest) {
        return false;
    }

    protected void addExtraLayer(String layer) {
        this.extraLayers.add(layer);
    }

    private void copyProjectFile(Path targetDir) throws IOException, MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String fileName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || fileName.endsWith(WAR)) && this.contextRoot) {
            fileName = "ROOT.war";
        }
        Files.copy(f.toPath(), targetDir.resolve(fileName), new CopyOption[0]);
    }

    protected Path getDeploymentsDir() {
        return Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("deployments");
    }

    protected void configureCli(List<String> commands) {
    }

    protected File validateProjectFile() throws MojoExecutionException {
        File f = this.getProjectFile();
        if (f == null && !this.hollowJar) {
            throw new MojoExecutionException("Cannot package without a primary artifact; please `mvn package` prior to invoking wildfly-jar:package from the command-line");
        }
        return f;
    }

    private void userScripts(Path wildflyDir, List<CliSession> sessions, boolean startEmbedded) throws Exception {
        for (CliSession session : sessions) {
            ArrayList<String> commands = new ArrayList<String>();
            for (String path : session.getScriptFiles()) {
                File f = new File(path);
                Path filePath = this.resolvePath(f.toPath());
                if (Files.notExists(filePath, new LinkOption[0])) {
                    throw new RuntimeException("Cli script file " + filePath + " doesn't exist");
                }
                try (BufferedReader reader = new BufferedReader(new FileReader(filePath.toFile()));){
                    String line = reader.readLine();
                    while (line != null) {
                        commands.add(line.trim());
                        line = reader.readLine();
                    }
                }
            }
            if (commands.isEmpty()) continue;
            this.executeCliScript(wildflyDir, commands, session.getPropertiesFile(), session.getResolveExpression(), session.toString(), startEmbedded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCliScript(Path jbossHome, List<String> commands, String propertiesFile, boolean resolveExpression, String message, boolean startEmbedded) throws Exception {
        this.getLog().info((CharSequence)("Executing CLI, " + message));
        Properties props = null;
        if (propertiesFile != null) {
            props = this.loadProperties(propertiesFile);
        }
        try {
            this.processCLI(jbossHome, commands, resolveExpression, startEmbedded);
        }
        finally {
            if (props != null) {
                for (String key : props.stringPropertyNames()) {
                    WildFlySecurityManager.clearPropertyPrivileged((String)key);
                }
            }
        }
    }

    private void generateLoggingConfig(Path wildflyDir) throws Exception {
        try (CLIExecutor cmdCtx = this.forkCli ? new RemoteCLIExecutor(wildflyDir, this.getCLIArtifacts(), this, false) : new LocalCLIExecutor(wildflyDir, this.getCLIArtifacts(), this, false, this.bootLoggingConfiguration);){
            try {
                cmdCtx.generateBootLoggingConfig();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to generate logging configuration: " + cmdCtx.getOutput()));
                throw e;
            }
        }
    }

    private void processCLI(Path jbossHome, List<String> commands, boolean resolveExpression, boolean startEmbedded) throws Exception {
        ArrayList<String> allCommands = new ArrayList<String>();
        if (startEmbedded) {
            allCommands.add("embed-server --jboss-home=" + jbossHome + " --std-out=discard");
        }
        for (String line : commands) {
            allCommands.add(line.trim());
        }
        if (startEmbedded) {
            allCommands.add("stop-embedded-server");
        }
        try (CLIExecutor executor = this.forkCli ? new RemoteCLIExecutor(jbossHome, this.getCLIArtifacts(), this, resolveExpression) : new LocalCLIExecutor(jbossHome, this.getCLIArtifacts(), this, resolveExpression, this.bootLoggingConfiguration);){
            try {
                executor.execute(allCommands);
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("Error executing CLI script " + ex.getLocalizedMessage()), (Throwable)ex);
                this.getLog().error((CharSequence)executor.getOutput());
                throw ex;
            }
            if (this.displayCliScriptsOutput) {
                this.getLog().info((CharSequence)executor.getOutput());
            }
        }
        this.getLog().info((CharSequence)"CLI scripts execution done.");
    }

    private List<Path> getCLIArtifacts() throws MojoExecutionException {
        this.debug("CLI artifacts %s", this.scannedArtifacts.getCliArtifacts());
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.wildflyDir.resolve("jboss-modules.jar"));
        for (MavenArtifact a : this.scannedArtifacts.getCliArtifacts()) {
            paths.add(this.resolveArtifact(a));
        }
        return paths;
    }

    public Level disableLog() {
        Logger l = Logger.getLogger("");
        Level level = l.getLevel();
        if (!this.getLog().isDebugEnabled()) {
            l.setLevel(Level.OFF);
        }
        return level;
    }

    public void enableLog(Level level) {
        Logger l = Logger.getLogger("");
        l.setLevel(level);
    }

    private Path resolvePath(Path path) {
        if (!path.isAbsolute()) {
            path = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(path);
        }
        return path;
    }

    private Properties loadProperties(String propertiesFile) throws Exception {
        File f = new File(propertiesFile);
        Path filePath = this.resolvePath(f.toPath());
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new RuntimeException("Cli properties file " + filePath + " doesn't exist");
        }
        Properties props = new Properties();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(filePath.toFile()), StandardCharsets.UTF_8);){
            props.load(inputStreamReader);
        }
        catch (IOException e) {
            throw new Exception("Failed to load properties from " + propertiesFile + ": " + e.getLocalizedMessage());
        }
        for (String key : props.stringPropertyNames()) {
            WildFlySecurityManager.setPropertyPrivileged((String)key, (String)props.getProperty(key));
        }
        return props;
    }

    private File getProjectFile() {
        if (this.project.getArtifact().getFile() != null) {
            return this.project.getArtifact().getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        Path candidate = Paths.get(this.projectBuildDir, finalName + "." + this.project.getPackaging());
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toFile();
        }
        return null;
    }

    protected Path getProvisioningFile() {
        return this.resolvePath(this.provisioningFile.toPath());
    }

    protected boolean hasLayers() {
        return !this.layers.isEmpty();
    }

    protected List<String> getLayers() {
        return this.layers;
    }

    protected List<String> getExcludedLayers() {
        return this.excludedLayers;
    }

    private GalleonConfig buildFeaturePacksConfig(GalleonBuilder pm, boolean hasLayers, ConfigId defaultConfig) throws ProvisioningException, MojoExecutionException {
        GalleonProvisioningConfig.Builder state = GalleonProvisioningConfig.builder();
        ConfigId provisionedConfigId = null;
        for (FeaturePack fp : this.featurePacks) {
            FeaturePackLocation fpl;
            if (fp.getLocation() == null && (fp.getGroupId() == null || fp.getArtifactId() == null) && fp.getNormalizedPath() == null) {
                throw new MojoExecutionException("Feature-pack location, Maven GAV or feature pack path is missing");
            }
            if (fp.getNormalizedPath() != null) {
                fpl = pm.addLocal(fp.getNormalizedPath(), false);
            } else if (fp.getGroupId() != null && fp.getArtifactId() != null) {
                String coords = fp.getMavenCoords();
                fpl = FeaturePackLocation.fromString((String)coords);
            } else {
                fpl = FeaturePackLocation.fromString((String)fp.getLocation());
            }
            GalleonFeaturePackConfig.Builder fpConfig = GalleonFeaturePackConfig.builder((FeaturePackLocation)fpl);
            fpConfig.setInheritConfigs(false);
            if (fp.isInheritPackages() != null) {
                fpConfig.setInheritPackages(fp.isInheritPackages().booleanValue());
            }
            if (fp.getIncludedDefaultConfig() != null) {
                ConfigId includedConfigId = new ConfigId(STANDALONE, fp.getIncludedDefaultConfig());
                fpConfig.includeDefaultConfig(includedConfigId);
                if (provisionedConfigId == null) {
                    provisionedConfigId = includedConfigId;
                } else if (!provisionedConfigId.getName().equals(fp.getIncludedDefaultConfig())) {
                    throw new ProvisioningException("Feature-packs are not including the same default config");
                }
            } else if (!hasLayers && provisionedConfigId == null) {
                provisionedConfigId = defaultConfig;
                fpConfig.includeDefaultConfig(provisionedConfigId);
            }
            if (!fp.getIncludedPackages().isEmpty()) {
                for (String includedPackage : fp.getIncludedPackages()) {
                    fpConfig.includePackage(includedPackage);
                }
            }
            if (!fp.getExcludedPackages().isEmpty()) {
                for (String excludedPackage : fp.getExcludedPackages()) {
                    fpConfig.excludePackage(excludedPackage);
                }
            }
            state.addFeaturePackDep(fpConfig.build());
        }
        if (hasLayers) {
            this.getLog().info((CharSequence)"Provisioning server configuration based on the set of configured layers");
        } else {
            this.getLog().info((CharSequence)("Provisioning server configuration based on the " + provisionedConfigId.getName() + " default configuration."));
        }
        return hasLayers ? new LayersFeaturePacksConfig(state) : new DefaultFeaturePacksConfig(provisionedConfigId, state);
    }

    private static GalleonConfigurationWithLayersBuilder buildConfiguration(String model, String name) {
        return GalleonConfigurationWithLayersBuilder.builder((String)model, (String)name);
    }

    private static GalleonConfigurationWithLayersBuilder buildDefaultConfig(ConfigId defaultConfigId) {
        Objects.requireNonNull(defaultConfigId);
        GalleonConfigurationWithLayersBuilder config = AbstractBuildBootableJarMojo.buildConfiguration(defaultConfigId.getModel(), defaultConfigId.getName());
        HashMap props = new HashMap();
        config.setProperty(SERVER_CONFIG, STANDALONE_XML);
        return config;
    }

    private void normalizeFeaturePackList() throws MojoExecutionException {
        if (this.featurePackLocation != null && !this.featurePacks.isEmpty()) {
            throw new MojoExecutionException("feature-pack-location can't be used with a list of feature-packs");
        }
        if (this.featurePackLocation != null) {
            this.featurePackLocation = this.isChannelsProvisioning() ? this.formatLocation(this.featurePackLocation) : MavenUpgrade.locationWithVersion(this.featurePackLocation, this.artifactVersions);
            this.featurePacks = new ArrayList<FeaturePack>();
            FeaturePack fp = new FeaturePack();
            fp.setLocation(this.featurePackLocation);
            this.featurePacks.add(fp);
        } else {
            for (FeaturePack fp : this.featurePacks) {
                if (fp.getLocation() != null) {
                    if (this.isChannelsProvisioning()) {
                        fp.setLocation(this.formatLocation(fp.getLocation()));
                        continue;
                    }
                    fp.setLocation(MavenUpgrade.locationWithVersion(fp.getLocation(), this.artifactVersions));
                    continue;
                }
                if (fp.getGroupId() == null || fp.getArtifactId() == null) {
                    throw new MojoExecutionException("Invalid Maven coordinates for galleon feature-pack ");
                }
                if (fp.getVersion() != null || this.isChannelsProvisioning()) continue;
                Artifact fpArtifact = this.artifactVersions.getFeaturePackArtifact(fp.getGroupId(), fp.getArtifactId(), fp.getClassifier());
                if (fpArtifact == null) {
                    throw new MojoExecutionException("No version found for " + fp.getGAC());
                }
                fp.setVersion(fpArtifact.getVersion());
            }
        }
    }

    private String formatLocation(String location) {
        long numSeparators;
        if (!FeaturePackLocation.fromString((String)location).hasUniverse() && (numSeparators = ((String)location).chars().filter(ch -> ch == 58).count()) <= 1L) {
            location = (String)location + ":";
        }
        return location;
    }

    private GalleonProvisioningConfig buildGalleonConfig(GalleonBuilder provider, ConfigId defaultConfig) throws ProvisioningException, MojoExecutionException {
        boolean isLayerBasedConfig = !this.layers.isEmpty();
        boolean hasFeaturePack = !this.featurePacks.isEmpty();
        boolean hasProvisioningFile = Files.exists(this.getProvisioningFile(), new LinkOption[0]);
        if (!hasFeaturePack && !hasProvisioningFile) {
            throw new ProvisioningException("No valid provisioning configuration, you must set a feature-pack-location, a list of feature-packs or use a provisioning.xml file");
        }
        if (hasFeaturePack && hasProvisioningFile) {
            this.getLog().warn((CharSequence)("Feature packs defined in pom.xml override provisioning file located in " + this.getProvisioningFile()));
        }
        if (isLayerBasedConfig) {
            if (!hasFeaturePack) {
                throw new ProvisioningException("No server feature-pack location to provision layers, you must set a feature-pack-location");
            }
            return this.buildFeaturePacksConfig(provider, true, defaultConfig).buildProvisioningConfig();
        }
        if (!this.featurePacks.isEmpty()) {
            this.getLog().info((CharSequence)"Provisioning server using feature-packs");
            return this.buildFeaturePacksConfig(provider, isLayerBasedConfig, defaultConfig).buildProvisioningConfig();
        }
        if (hasProvisioningFile) {
            this.getLog().info((CharSequence)("Provisioning server using " + this.getProvisioningFile()));
            return new ProvisioningFileConfig(provider).buildProvisioningConfig();
        }
        throw new ProvisioningException("Invalid Galleon configuration");
    }

    private ConfigId willProvision(List<FeaturePack> featurePacks, GalleonBuilder provider) throws MojoExecutionException, ProvisioningException, IOException {
        Utils.ProvisioningSpecifics specifics = Utils.getSpecifics(featurePacks, provider);
        return this.willProvision(specifics);
    }

    protected abstract ConfigId willProvision(Utils.ProvisioningSpecifics var1) throws MojoExecutionException;

    private void provisionServer(Path home, Path outputProvisioningFile, Path workDir) throws ProvisioningException, MojoExecutionException, IOException, XMLStreamException {
        GalleonBuilder provider = new GalleonBuilder();
        provider.addArtifactResolver((RepositoryArtifactResolver)this.artifactResolver);
        this.normalizeFeaturePackList();
        ConfigId defaultConfig = this.willProvision(this.featurePacks, provider);
        GalleonProvisioningConfig config = this.buildGalleonConfig(provider, defaultConfig);
        try (Provisioning pm = provider.newProvisioningBuilder(config).setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();){
            Path file;
            GalleonProvisioningConfig newConfig;
            IoUtils.recursiveDelete((Path)home);
            this.getLog().info((CharSequence)("Building server based on " + config.getFeaturePackDeps() + " galleon feature-packs"));
            MavenUpgrade mavenUpgrade = null;
            if (this.isChannelsProvisioning()) {
                if (!this.overriddenServerArtifacts.isEmpty()) {
                    throw new MojoExecutionException("overridden-server-artifacts can't be configured when channels are configured.");
                }
                newConfig = config;
            } else {
                mavenUpgrade = new MavenUpgrade(this, pm, config);
                if (this.dumpOriginalArtifacts) {
                    file = workDir.resolve("bootable-jar-server-original-artifacts.xml");
                    this.getLog().info((CharSequence)("Dumping original Maven artifacts in " + file));
                    mavenUpgrade.dumpArtifacts(file);
                }
                newConfig = mavenUpgrade.upgrade();
            }
            pm.storeProvisioningConfig(newConfig, outputProvisioningFile);
            try {
                this.scannedArtifacts = BootableJarSupport.scanArtifacts((Provisioning)pm, (GalleonProvisioningConfig)newConfig, (MessageWriter)new MvnMessageWriter(this.getLog()));
            }
            catch (Exception ex) {
                throw new MojoExecutionException((Throwable)ex);
            }
            PluginProgressTracker.initTrackers((Provisioning)pm, (org.jboss.logging.Logger)new MavenJBossLogger(this.getLog()));
            pm.provision(newConfig);
            if (!this.recordState) {
                file = home.resolve(PLUGIN_PROVISIONING_FILE);
                pm.storeProvisioningConfig(newConfig, file);
            }
        }
    }

    static Artifact getArtifact(String str) {
        String[] parts = str.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String classifier = parts[3];
        String extension = parts[4];
        return new DefaultArtifact(groupId, artifactId, version, "provided", extension, classifier, (ArtifactHandler)new DefaultArtifactHandler(extension));
    }

    static void readProperties(Path propsFile, Map<String, String> propsMap) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#') {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new Exception("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
    }

    private void deploy(List<String> commands) throws MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String runtimeName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || runtimeName.endsWith(WAR)) && this.contextRoot) {
            runtimeName = "ROOT.war";
        }
        commands.add("deploy " + f.getAbsolutePath() + " --name=" + f.getName() + " --runtime-name=" + runtimeName);
    }

    private OverriddenArtifact getOverriddenArtifact(String grpId, String artifactId) {
        OverriddenArtifact ret = null;
        for (OverriddenArtifact art : this.overriddenServerArtifacts) {
            if (!art.getGroupId().equals(grpId) || !art.getArtifactId().equals(artifactId)) continue;
            ret = art;
            break;
        }
        return ret;
    }

    private void buildJar(Path contentDir, Path jarFile) throws MojoExecutionException, IOException {
        Path rtJarFile = this.resolveArtifact(this.scannedArtifacts.getBoot());
        Path contentRoot = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.bootableJarBuildArtifacts);
        Path tmpDir = contentRoot.resolve("tmp_runtime");
        Files.createDirectories(tmpDir, new FileAttribute[0]);
        ZipUtils.unzip((Path)rtJarFile, (Path)tmpDir);
        OverriddenArtifact modules = this.getOverriddenArtifact("org.jboss.modules", "jboss-modules");
        Path jbossModulesDependency = tmpDir.resolve("META-INF").resolve("maven").resolve("org.jboss.modules").resolve("jboss-modules").resolve("pom.xml");
        if (Files.exists(jbossModulesDependency, new LinkOption[0])) {
            if (modules != null) {
                this.getLog().warn((CharSequence)"Bootable JAR dependency on jboss-modules can't be upgraded, you must use a more recent version of the server.");
            }
        } else {
            if (modules != null) {
                this.scannedArtifacts.getJbossModules().setVersion(modules.getVersion());
            }
            Path jbossModulesFile = this.resolveArtifact(this.scannedArtifacts.getJbossModules());
            ZipUtils.unzip((Path)jbossModulesFile, (Path)contentDir);
        }
        ZipUtils.unzip((Path)rtJarFile, (Path)contentDir);
        this.updateManifest(contentDir);
        ZipUtils.zip((Path)contentDir, (Path)jarFile);
    }

    private void updateManifest(Path target) throws IOException {
        boolean updated;
        Manifest manifest;
        Path targetMetaInf = target.resolve("META-INF");
        Path targetManifestPath = targetMetaInf.resolve("MANIFEST.MF");
        try (FileInputStream stream = new FileInputStream(targetManifestPath.toFile());){
            manifest = new Manifest(stream);
            updated = this.updateManifest(manifest);
        }
        if (updated) {
            Files.deleteIfExists(targetManifestPath);
            try (FileOutputStream out = new FileOutputStream(targetManifestPath.toFile());){
                manifest.write(out);
            }
        }
    }

    public String retrievePluginVersion() throws PlexusConfigurationException, MojoExecutionException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/plugin.xml");
        if (is == null) {
            throw new MojoExecutionException("Can't retrieve plugin descriptor");
        }
        PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
        PluginDescriptor pluginDescriptor = builder.build((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        return pluginDescriptor.getVersion();
    }

    public Path resolveArtifact(String groupId, String artifactId, String classifier, String version) throws UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        MavenArtifact ma = new MavenArtifact();
        ma.setGroupId(groupId);
        ma.setArtifactId(artifactId);
        ma.setVersion(version);
        ma.setClassifier(classifier);
        ma.setExtension(JAR);
        return this.resolveArtifact(ma);
    }

    Path resolveArtifact(MavenArtifact mavenArtifact) throws MojoExecutionException {
        try {
            if (!mavenArtifact.isResolved()) {
                this.resolve(mavenArtifact);
            }
            return mavenArtifact.getPath();
        }
        catch (IOException | MavenUniverseException ex) {
            throw new MojoExecutionException(ex.toString(), (Exception)ex);
        }
    }

    private void resolve(MavenArtifact artifact) throws MavenUniverseException, IOException {
        this.artifactResolver.resolve(artifact);
    }

    public MavenRepoManager getArtifactResolver() {
        return this.artifactResolver;
    }

    private void attachJar(Path jarFile) {
        this.debug("Attaching bootable jar %s as a project artifact with classifier %s", jarFile, this.installArtifactClassifier);
        this.projectHelper.attachArtifact(this.project, JAR, this.installArtifactClassifier, jarFile.toFile());
    }

    void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }

    static void deleteDir(Path root) {
        if (root == null || Files.notExists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Path resolveMaven(GalleonArtifactCoordinate coordinate) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact().setGroupId(coordinate.getGroupId()).setArtifactId(coordinate.getArtifactId()).setVersion(coordinate.getVersion()).setExtension(coordinate.getExtension()).setClassifier(coordinate.getClassifier());
        this.artifactResolver.resolve(artifact);
        return artifact.getPath();
    }

    private class LayersFeaturePacksConfig
    extends AbstractLayersConfig {
        private final GalleonProvisioningConfig.Builder state;

        private LayersFeaturePacksConfig(GalleonProvisioningConfig.Builder state) throws ProvisioningDescriptionException, ProvisioningException {
            this.state = state;
        }

        @Override
        public GalleonProvisioningConfig.Builder buildState() throws ProvisioningException {
            return this.state;
        }
    }

    private class DefaultFeaturePacksConfig
    extends AbstractDefaultConfig {
        private final GalleonProvisioningConfig.Builder state;

        private DefaultFeaturePacksConfig(ConfigId defaultConfigId, GalleonProvisioningConfig.Builder state) throws ProvisioningException {
            super(defaultConfigId);
            Objects.requireNonNull(state);
            this.state = state;
        }

        @Override
        protected GalleonProvisioningConfig.Builder buildState() throws ProvisioningException {
            return this.state;
        }
    }

    private static interface GalleonConfig {
        public GalleonProvisioningConfig buildProvisioningConfig() throws ProvisioningException;
    }

    private class ProvisioningFileConfig
    implements GalleonConfig {
        private final GalleonBuilder pm;

        ProvisioningFileConfig(GalleonBuilder pm) {
            Objects.requireNonNull(pm);
            this.pm = pm;
        }

        @Override
        public GalleonProvisioningConfig buildProvisioningConfig() throws ProvisioningException {
            try (Provisioning p = this.pm.newProvisioningBuilder(AbstractBuildBootableJarMojo.this.getProvisioningFile()).build();){
                GalleonProvisioningConfig galleonProvisioningConfig = p.loadProvisioningConfig(AbstractBuildBootableJarMojo.this.getProvisioningFile());
                return galleonProvisioningConfig;
            }
        }
    }

    private abstract class AbstractDefaultConfig
    extends AbstractGalleonConfig {
        private AbstractDefaultConfig(ConfigId defaultConfigId) throws ProvisioningException {
            super(AbstractBuildBootableJarMojo.buildDefaultConfig(defaultConfigId));
            for (String l : AbstractBuildBootableJarMojo.this.extraLayers) {
                this.configuration.includeLayer(l);
            }
            for (String l : AbstractBuildBootableJarMojo.this.excludedLayers) {
                this.configuration.excludeLayer(l);
            }
        }
    }

    private abstract class AbstractLayersConfig
    extends AbstractGalleonConfig {
        public AbstractLayersConfig() throws ProvisioningDescriptionException, ProvisioningException {
            super(AbstractBuildBootableJarMojo.buildConfiguration(AbstractBuildBootableJarMojo.STANDALONE, AbstractBuildBootableJarMojo.STANDALONE_XML));
            ArrayList<String> allLayers = new ArrayList<String>();
            allLayers.addAll(AbstractBuildBootableJarMojo.this.layers);
            allLayers.addAll(AbstractBuildBootableJarMojo.this.extraLayers);
            for (String l : allLayers) {
                this.configuration.includeLayer(l);
            }
            for (String l : AbstractBuildBootableJarMojo.this.excludedLayers) {
                this.configuration.excludeLayer(l);
            }
        }
    }

    private abstract class AbstractGalleonConfig
    implements GalleonConfig {
        protected final GalleonConfigurationWithLayersBuilder configuration;

        AbstractGalleonConfig(GalleonConfigurationWithLayersBuilder configuration) throws ProvisioningException {
            Objects.requireNonNull(configuration);
            this.configuration = configuration;
            this.setupPluginOptions();
        }

        @Override
        public GalleonProvisioningConfig buildProvisioningConfig() throws ProvisioningException {
            return this.buildConfig();
        }

        private void setupPluginOptions() throws ProvisioningException {
            if (AbstractBuildBootableJarMojo.this.pluginOptions.isEmpty()) {
                AbstractBuildBootableJarMojo.this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
            } else {
                Path path;
                String val;
                if (!AbstractBuildBootableJarMojo.this.pluginOptions.containsKey("optional-packages")) {
                    AbstractBuildBootableJarMojo.this.pluginOptions.put("optional-packages", "passive+");
                }
                if (AbstractBuildBootableJarMojo.this.pluginOptions.containsKey(AbstractBuildBootableJarMojo.MAVEN_REPO_PLUGIN_OPTION) && (val = AbstractBuildBootableJarMojo.this.pluginOptions.get(AbstractBuildBootableJarMojo.MAVEN_REPO_PLUGIN_OPTION)) != null && !(path = Paths.get(val, new String[0])).isAbsolute()) {
                    path = AbstractBuildBootableJarMojo.this.project.getBasedir().toPath().resolve(path);
                    AbstractBuildBootableJarMojo.this.pluginOptions.put(AbstractBuildBootableJarMojo.MAVEN_REPO_PLUGIN_OPTION, path.toString());
                }
            }
        }

        protected abstract GalleonProvisioningConfig.Builder buildState() throws ProvisioningException;

        public GalleonProvisioningConfig buildConfig() throws ProvisioningException {
            GalleonProvisioningConfig.Builder state = this.buildState();
            state.addConfig(this.configuration.build());
            state.addOptions(AbstractBuildBootableJarMojo.this.pluginOptions);
            return state.build();
        }
    }
}

