/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.common;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;

public class OverriddenArtifact
implements DependableCoordinate {
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "jar";
    private String classifier;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getGAC() {
        return this.getGroupId() + ":" + this.getArtifactId() + (String)(this.getClassifier() == null ? "" : ":" + this.getClassifier());
    }

    public static OverriddenArtifact fromString(String str) throws MojoExecutionException {
        if (str == null) {
            throw new MojoExecutionException("Invalid null overriden artifact");
        }
        String[] parts = (str = str.trim()).split(":");
        if (parts.length < 2) {
            throw new MojoExecutionException("Unexpected artifact coordinates format: " + str);
        }
        OverriddenArtifact artifact = new OverriddenArtifact();
        artifact.setGroupId(OverriddenArtifact.check(parts[0], str));
        artifact.setArtifactId(OverriddenArtifact.check(parts[1], str));
        if (parts.length > 2) {
            String version = parts[2].trim();
            if (!version.isEmpty()) {
                artifact.setVersion(version);
            }
            if (parts.length > 3) {
                String classifier = parts[3].trim();
                artifact.setClassifier(classifier);
                if (parts.length > 4) {
                    String type = parts[4].trim();
                    if (!type.isEmpty()) {
                        artifact.setType(type);
                    }
                    if (parts.length > 5) {
                        throw new MojoExecutionException("Unexpected artifact coordinates format: " + str);
                    }
                }
            }
        }
        return artifact;
    }

    private static String check(String artifact, String item) {
        if (item != null) {
            item = item.trim();
        }
        if (item == null || item.isEmpty()) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + artifact);
        }
        return item;
    }
}

