/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.componentmatrix;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;

class PomDependencyVersionsTransformer {
    PomDependencyVersionsTransformer() {
    }

    public Model transformPomModel(Model model) {
        String groupId;
        Model pomModel = model.clone();
        DependencyManagement depMgmt = pomModel.getDependencyManagement();
        TreeMap<String, String> groupIdArtifactIdVersions = new TreeMap<String, String>();
        TreeMap<String, Object> groupIdArtifactIdPropertyNames = new TreeMap<String, Object>();
        TreeMap<String, String> groupIdVersions = new TreeMap<String, String>();
        TreeMap<String, HashSet<String>> groupIdArtifactIds = new TreeMap<String, HashSet<String>>();
        for (Dependency dependency : depMgmt.getDependencies()) {
            String groupId2 = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String groupIdArtifactId = groupId2 + ":" + artifactId;
            groupIdArtifactIdVersions.put(groupIdArtifactId, dependency.getVersion());
            groupIdVersions.put(groupId2, dependency.getVersion());
            HashSet<String> artifactIds = (HashSet<String>)groupIdArtifactIds.get(groupId2);
            if (artifactIds == null) {
                artifactIds = new HashSet<String>();
                groupIdArtifactIds.put(groupId2, artifactIds);
            }
            artifactIds.add(artifactId);
        }
        Properties properties = pomModel.getProperties();
        for (Map.Entry groupVersion : groupIdVersions.entrySet()) {
            groupId = (String)groupVersion.getKey();
            Set artifactIds = (Set)groupIdArtifactIds.get(groupId);
            if (artifactIds.size() == 1 || this.allArtifactsInGroupHaveSameVersion(groupId, groupIdArtifactIdVersions, artifactIds)) {
                String propertyName = "version." + groupId;
                properties.setProperty(propertyName, (String)groupVersion.getValue());
                for (String artifactId : artifactIds) {
                    String groupIdArtifactId = groupId + ":" + artifactId;
                    groupIdArtifactIdPropertyNames.put(groupIdArtifactId, propertyName);
                }
                continue;
            }
            for (String artifactId : artifactIds) {
                String groupIdArtifactId = groupId + ":" + artifactId;
                String propertyName = "version." + groupId + "." + artifactId;
                groupIdArtifactIdPropertyNames.put(groupIdArtifactId, propertyName);
                properties.setProperty(propertyName, (String)groupIdArtifactIdVersions.get(groupIdArtifactId));
            }
        }
        for (Dependency dependency : depMgmt.getDependencies()) {
            groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String groupIdArtifactId = groupId + ":" + artifactId;
            String propertyName = (String)groupIdArtifactIdPropertyNames.get(groupIdArtifactId);
            dependency.setVersion("${" + propertyName + "}");
        }
        return pomModel;
    }

    private boolean allArtifactsInGroupHaveSameVersion(String groupId, Map<String, String> groupIdArtifactIdVersions, Set<String> artifactIds) {
        String version = null;
        for (String artifactId : artifactIds) {
            String groupIdArtifactId = groupId + ":" + artifactId;
            if (version == null) {
                version = groupIdArtifactIdVersions.get(groupIdArtifactId);
                continue;
            }
            if (version.equals(groupIdArtifactIdVersions.get(groupIdArtifactId))) continue;
            return false;
        }
        return true;
    }
}

