/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.componentmatrix;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.wildfly.plugins.componentmatrix.BomExclusion;
import org.wildfly.plugins.componentmatrix.DependencyExclusion;
import org.wildfly.plugins.componentmatrix.DependencyId;
import org.wildfly.plugins.componentmatrix.OrderedProperties;
import org.wildfly.plugins.componentmatrix.PomDependencyVersionsTransformer;

@Mojo(name="build-bom", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildBomMojo
extends AbstractMojo {
    private static final String VERSION_PROPERTY_PREFIX = "version.";
    @Parameter
    private Parent parent;
    @Parameter(required=true)
    private String bomGroupId;
    @Parameter(required=true)
    private String bomArtifactId;
    @Parameter(required=true)
    private String bomVersion;
    @Parameter(defaultValue="")
    private String bomName;
    @Parameter(defaultValue="")
    private String bomDescription;
    @Parameter
    private boolean licenses = false;
    @Parameter(defaultValue="bom-pom.xml")
    String outputFilename;
    @Parameter
    private List<BomExclusion> exclusions;
    @Parameter
    private List<DependencyExclusion> dependencyExclusions;
    @Parameter
    private boolean inheritExclusions;
    @Parameter
    private Set<String> includeProfiles;
    @Component
    MavenProject mavenProject;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    private final PomDependencyVersionsTransformer versionsTransformer;
    private final ModelWriter modelWriter;

    public BuildBomMojo() {
        this(new ModelWriter(), new PomDependencyVersionsTransformer());
    }

    public BuildBomMojo(ModelWriter modelWriter, PomDependencyVersionsTransformer versionsTransformer) {
        this.versionsTransformer = versionsTransformer;
        this.modelWriter = modelWriter;
    }

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating BOM");
        Model model = this.initializeModel();
        this.addDependencyManagement(model);
        model = this.versionsTransformer.transformPomModel(model);
        this.getLog().debug((CharSequence)"Dependencies versions converted to properties");
        File file = new File(this.mavenProject.getBuild().getDirectory(), this.outputFilename);
        this.modelWriter.writeModel(model, file);
        Artifact projectArtifact = this.mavenProject.getArtifact();
        DefaultArtifact pomArtifact = new DefaultArtifact(this.bomGroupId, this.bomArtifactId, this.bomVersion, null, "pom", null, this.artifactHandlerManager.getArtifactHandler("pom"));
        pomArtifact.setFile(file);
        this.mavenProject.addAttachedArtifact((Artifact)pomArtifact);
    }

    private Model initializeModel() {
        Model pomModel = new Model();
        pomModel.setModelVersion("4.0.0");
        pomModel.setGroupId(this.bomGroupId);
        pomModel.setArtifactId(this.bomArtifactId);
        pomModel.setVersion(this.bomVersion);
        pomModel.setPackaging("pom");
        pomModel.setName(this.bomName);
        pomModel.setDescription(this.bomDescription);
        pomModel.setProperties((Properties)new OrderedProperties());
        pomModel.getProperties().setProperty("project.build.sourceEncoding", "UTF-8");
        if (this.licenses) {
            pomModel.setLicenses(this.mavenProject.getLicenses());
        }
        if (this.parent != null) {
            if (this.parent.getGroupId() == null) {
                throw new IllegalArgumentException("No groupId was set for the parent");
            }
            if (this.parent.getArtifactId() == null) {
                throw new IllegalArgumentException("No artifactId was set for the parent");
            }
            if (this.parent.getVersion() == null) {
                for (MavenProject current = this.mavenProject; current != null; current = current.getParent()) {
                    if (!current.getGroupId().equals(this.parent.getGroupId()) || !current.getArtifactId().equals(this.parent.getArtifactId())) continue;
                    this.parent.setVersion(current.getVersion());
                    break;
                }
                if (this.parent.getVersion() == null) {
                    throw new IllegalArgumentException("No version was set for the parent " + this.parent.getGroupId() + ":" + this.parent.getArtifactId() + " and it cannot be determined from the parents of the consuming pom");
                }
            }
            pomModel.setParent(this.parent);
        }
        HashSet<String> addedProfiles = new HashSet<String>();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (MavenProject current = this.mavenProject; current != null; current = current.getParent()) {
            Model currModel = current.getModel();
            if (this.includeProfiles == null || currModel == null) continue;
            for (Profile profile : currModel.getProfiles()) {
                if (!this.includeProfiles.contains(profile.getId()) || addedProfiles.contains(profile.getId())) continue;
                profiles.add(profile);
                addedProfiles.add(profile.getId());
            }
        }
        if (profiles.size() > 0) {
            pomModel.setProfiles(profiles);
        }
        return pomModel;
    }

    private void addDependencyManagement(Model pomModel) {
        Properties versionProperties = new Properties();
        DependencyManagement depMgmt = new DependencyManagement();
        for (Dependency originalDependency : this.mavenProject.getDependencyManagement().getDependencies()) {
            if (this.isExcludedDependency(originalDependency)) continue;
            String versionPropertyName = VERSION_PROPERTY_PREFIX + originalDependency.getGroupId();
            if (versionProperties.getProperty(versionPropertyName) != null && !versionProperties.getProperty(versionPropertyName).equals(originalDependency.getVersion())) {
                versionPropertyName = VERSION_PROPERTY_PREFIX + originalDependency.getGroupId() + "." + originalDependency.getArtifactId();
            }
            versionProperties.setProperty(versionPropertyName, originalDependency.getVersion());
            Dependency dep = new Dependency();
            dep.setGroupId(originalDependency.getGroupId());
            dep.setArtifactId(originalDependency.getArtifactId());
            dep.setVersion(originalDependency.getVersion());
            if (!StringUtils.isEmpty((String)originalDependency.getClassifier())) {
                dep.setClassifier(originalDependency.getClassifier());
            }
            if (!StringUtils.isEmpty((String)originalDependency.getType())) {
                dep.setType(originalDependency.getType());
            }
            if (!StringUtils.isEmpty((String)originalDependency.getScope())) {
                dep.setScope(originalDependency.getScope());
            }
            if (this.exclusions != null) {
                this.applyExclusions(originalDependency, dep);
            }
            if (this.inheritExclusions) {
                this.inheritExclusions(originalDependency, dep);
            }
            depMgmt.addDependency(dep);
        }
        pomModel.setDependencyManagement(depMgmt);
        this.getLog().debug((CharSequence)("Added " + depMgmt.getDependencies().size() + " dependencies to dependency management."));
    }

    private void inheritExclusions(Dependency originalDependency, Dependency dep) {
        for (Exclusion originalExclusion : originalDependency.getExclusions()) {
            dep.addExclusion(originalExclusion.clone());
        }
    }

    boolean isExcludedDependency(Dependency dependency) {
        if (this.dependencyExclusions == null || this.dependencyExclusions.size() == 0) {
            return false;
        }
        for (DependencyExclusion exclusion : this.dependencyExclusions) {
            if (!this.matchesExcludedDependency(dependency, exclusion)) continue;
            this.getLog().debug((CharSequence)("Artifact " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " matches excluded dependency " + exclusion.getGroupId() + ":" + exclusion.getArtifactId()));
            return true;
        }
        return false;
    }

    boolean matchesExcludedDependency(Dependency artifact, DependencyExclusion exclusion) {
        String groupId = this.defaultAndTrim(artifact.getGroupId());
        String artifactId = this.defaultAndTrim(artifact.getArtifactId());
        String exclusionGroupId = this.defaultAndTrim(exclusion.getGroupId());
        String exclusionArtifactId = this.defaultAndTrim(exclusion.getArtifactId());
        boolean groupIdMatched = "*".equals(exclusionGroupId) || groupId.equals(exclusionGroupId);
        boolean artifactIdMatched = "*".equals(exclusionArtifactId) || artifactId.equals(exclusionArtifactId);
        return groupIdMatched && artifactIdMatched;
    }

    private String defaultAndTrim(String string) {
        return StringUtils.defaultString((Object)StringUtils.trim((String)string), (String)"");
    }

    private void applyExclusions(Dependency artifact, Dependency dep) {
        for (BomExclusion exclusion : this.exclusions) {
            if (!exclusion.getDependencyGroupId().equals(artifact.getGroupId()) || !exclusion.getDependencyArtifactId().equals(artifact.getArtifactId())) continue;
            Exclusion ex = new Exclusion();
            ex.setGroupId(exclusion.getExclusionGroupId());
            ex.setArtifactId(exclusion.getExclusionArtifactId());
            dep.addExclusion(ex);
        }
    }

    private Map<DependencyId, Dependency> createDependencyMap(DependencyManagement dependencyManagement) {
        if (dependencyManagement == null) {
            return Collections.emptyMap();
        }
        HashMap<DependencyId, Dependency> dependencyMap = new HashMap<DependencyId, Dependency>();
        for (Dependency dep : dependencyManagement.getDependencies()) {
            dependencyMap.put(new DependencyId(dep), dep);
        }
        return dependencyMap;
    }

    static class ModelWriter {
        ModelWriter() {
        }

        void writeModel(Model pomModel, File outputFile) throws MojoExecutionException {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(outputFile);){
                MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
                mavenWriter.write((Writer)writer, pomModel);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException("Unable to write pom file.", (Exception)e);
            }
        }
    }
}

