/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.DocumentHeader;
import org.asciidoctor.ast.StructuredDocument;

public class MetaData {
    private final String name;
    private String author;
    private String level;
    private String summary;
    private String targetProduct;
    private String source;
    private String prerequisites;
    private String[] technologies;
    private boolean openshift;

    public static MetaData parseReadme(Path quickstartDir) throws IOException {
        Path path = quickstartDir.resolve("README.adoc");
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        Options options = new Options();
        options.setSafe(SafeMode.UNSAFE);
        StructuredDocument doc = asciidoctor.readDocumentStructure(path.toFile(), options.map());
        DocumentHeader header = doc.getHeader();
        MetaData metaData = new MetaData(quickstartDir.getFileName().toString());
        metaData.setAttributes(header.getAttributes());
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String line;
            boolean shouldReadAbstract = false;
            while ((line = reader.readLine()) != null) {
                if (shouldReadAbstract) {
                    metaData.summary = line;
                    break;
                }
                if (!"[abstract]".equals(line.trim())) continue;
                shouldReadAbstract = true;
            }
        }
        return metaData;
    }

    private MetaData(String name) {
        this.name = name;
    }

    private void setAttributes(Map<String, Object> attributes) {
        if (attributes.containsKey("author")) {
            this.author = attributes.get("author").toString();
        }
        if (attributes.containsKey("technologies")) {
            this.technologies = attributes.get("technologies").toString().split(",");
        }
        if (attributes.containsKey("level")) {
            this.level = attributes.get("level").toString().trim();
        }
        if (attributes.containsKey("productName")) {
            this.targetProduct = attributes.get("productName").toString().trim();
        }
        if (attributes.containsKey("source")) {
            this.source = attributes.get("source").toString().trim().replaceAll("<", "").replaceAll(">", "");
        }
        if (attributes.containsKey("prerequisites")) {
            this.prerequisites = attributes.get("prerequisites").toString().trim();
        }
        if (attributes.containsKey("openshift")) {
            this.openshift = Boolean.parseBoolean(attributes.get("openshift").toString());
        }
    }

    String getTechnologiesAsString() {
        return Arrays.stream(this.technologies).map(String::trim).collect(Collectors.joining(", "));
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getTargetProduct() {
        return this.targetProduct;
    }

    public void setTargetProduct(String targetProduct) {
        this.targetProduct = targetProduct;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String[] getTechnologies() {
        return this.technologies;
    }

    public void setTechnologies(String[] technologies) {
        this.technologies = technologies;
    }

    public boolean isOpenshift() {
        return this.openshift;
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", author='" + this.author + '\'' + ", level='" + this.level + '\'' + ", summary='" + this.summary + '\'' + ", targetProduct='" + this.targetProduct + '\'' + ", source='" + this.source + '\'' + ", prerequisites='" + this.prerequisites + '\'' + ", openshift='" + this.openshift + '\'' + ", technologies=" + Arrays.toString(this.technologies) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)o;
        return Objects.equals(this.getName(), metaData.getName()) && Objects.equals(this.getAuthor(), metaData.getAuthor()) && Objects.equals(this.getLevel(), metaData.getLevel()) && Objects.equals(this.getSummary(), metaData.getSummary()) && Objects.equals(this.getTargetProduct(), metaData.getTargetProduct()) && Objects.equals(this.getSource(), metaData.getSource()) && Objects.equals(this.getPrerequisites(), metaData.getPrerequisites()) && Arrays.equals(this.getTechnologies(), metaData.getTechnologies());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAuthor(), this.getLevel(), this.getSummary(), this.getTargetProduct(), this.getSource(), this.getPrerequisites(), this.getTechnologies());
    }
}

