/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation.drupal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dk.nykredit.jackson.dataformat.hal.HALMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.logging.Log;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.DrupalSitemapParser;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.SitemapEntry;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.CodingResource;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.Product;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.Tag;

public class DrupalCommunication {
    private volatile String csrfToken;
    private Executor executor;
    private volatile List<Product> products;
    private volatile List<Tag> tags;
    private volatile List<SitemapEntry> sitemapEntries;
    private Log log;
    private final String drupalLocation;
    private String username;
    private String password;

    public DrupalCommunication(String username, String password, String drupalLocation, Log log) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();
        this.executor = Executor.newInstance((HttpClient)client);
        this.log = log;
        if (drupalLocation.endsWith("/")) {
            drupalLocation = drupalLocation.substring(0, drupalLocation.length() - 1);
        }
        this.drupalLocation = drupalLocation;
        this.username = username;
        this.password = password;
        try {
            this.log.debug((CharSequence)"Obtaining token from Drupal");
            this.executor.execute(Request.Post((String)(drupalLocation + "/user/login")).bodyForm(new NameValuePair[]{new BasicNameValuePair("name", username), new BasicNameValuePair("pass", password), new BasicNameValuePair("form_id", "user_login_form")})).discardContent();
            if (cookieStore.getCookies().size() < 1) {
                throw new SecurityException("Could not login to Drupal");
            }
            ((BasicClientCookie)cookieStore.getCookies().get(0)).setPath(null);
            Response response = this.executor.execute(Request.Get((String)(drupalLocation + "/session/token")));
            this.csrfToken = response.returnContent().asString();
            this.log.debug((CharSequence)("csrfToken = " + this.csrfToken));
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Could not obtain a security token from Drupal.", (Throwable)e);
            throw new SecurityException("Could not obtain a token from Drupal. Cannot continue.", e);
        }
        this.products = new ArrayList<Product>();
        this.tags = new ArrayList<Tag>();
        this.sitemapEntries = new ArrayList<SitemapEntry>();
    }

    synchronized List<Product> getProducts() {
        if (!this.products.isEmpty()) {
            return this.products;
        }
        try {
            this.log.debug((CharSequence)"Retrieving products from Drupal");
            Request sitemapRequest = Request.Get((String)(this.drupalLocation + "/drupal/products")).addHeader("X-CSRF-Token", this.csrfToken);
            String jsonProducts = this.executor.execute(sitemapRequest).returnContent().asString(Charset.forName("UTF-8"));
            ObjectMapper mapper = new ObjectMapper();
            this.products = (List)mapper.readValue(jsonProducts, (TypeReference)new TypeReference<List<Product>>(){});
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error retrieving products from Drupal", (Throwable)e);
        }
        return this.products;
    }

    synchronized List<Tag> getTags() {
        if (!this.tags.isEmpty()) {
            return this.tags;
        }
        try {
            this.log.debug((CharSequence)"Retrieving tags from Drupal");
            Request sitemapRequest = Request.Get((String)(this.drupalLocation + "/drupal/taxonomy/tags")).addHeader("X-CSRF-Token", this.csrfToken);
            String jsonTags = this.executor.execute(sitemapRequest).returnContent().asString(Charset.forName("UTF-8"));
            ObjectMapper mapper = new ObjectMapper();
            this.tags = (List)mapper.readValue(jsonTags, (TypeReference)new TypeReference<List<Tag>>(){});
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error retrieving products from Drupal", (Throwable)e);
        }
        return this.tags;
    }

    public boolean postNewCodingResource(CodingResource resource) {
        this.log.info((CharSequence)("adding new resource: " + resource.getPath()));
        HALMapper halMapper = new HALMapper();
        try {
            String json = halMapper.writeValueAsString((Object)resource);
            json = json.replaceAll("%drupalLocation%", this.drupalLocation);
            Request postQuickstart = Request.Post((String)String.format("%s/entity/node?_format=hal_json", this.drupalLocation)).addHeader("X-CSRF-Token", this.csrfToken).addHeader("accept", "*/*").bodyString(json, ContentType.create((String)"application/hal+json"));
            this.executor.auth(this.username, this.password);
            this.executor.authPreemptive(this.drupalLocation);
            return (Boolean)this.executor.execute(postQuickstart).handleResponse(response -> {
                if (response.getStatusLine().getStatusCode() != 201) {
                    this.log.error((CharSequence)String.format("Post new resource failed with response %s - %s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    return false;
                }
                return true;
            });
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error POSTing new coding resource to Drupal", (Throwable)e);
            return false;
        }
    }

    public boolean updateCodingResource(CodingResource resource) {
        this.log.info((CharSequence)("updating resource: " + resource.getPath()));
        HALMapper halMapper = new HALMapper();
        try {
            String json = halMapper.writeValueAsString((Object)resource);
            json = json.replaceAll("%drupalLocation%", this.drupalLocation);
            this.log.debug((CharSequence)("Patching existing entry to Drupal using json: " + json));
            Request postQuickstart = Request.Patch((String)String.format("%s%s?_format=hal_json", this.drupalLocation, resource.getPath().get(0))).addHeader("X-CSRF-Token", this.csrfToken).addHeader("accept", "*/*").bodyString(json, ContentType.create((String)"application/hal+json"));
            this.log.debug((CharSequence)("postQuickstart = " + postQuickstart));
            this.executor.auth(this.username, this.password);
            this.executor.authPreemptive(this.drupalLocation);
            return (Boolean)this.executor.execute(postQuickstart).handleResponse(response -> {
                if (response.getStatusLine().getStatusCode() != 200) {
                    this.log.error((CharSequence)String.format("Update failed with response %s - %s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    this.log.error((CharSequence)("error: " + EntityUtils.toString((HttpEntity)response.getEntity())));
                    return false;
                }
                return true;
            });
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error POSTing new coding resource to Drupal", (Throwable)e);
            return false;
        }
    }

    public synchronized List<SitemapEntry> getEntriesOfType(String type) {
        if (!this.sitemapEntries.isEmpty()) {
            return this.sitemapEntries;
        }
        try {
            this.log.debug((CharSequence)"Obtaining sitemap.xml from Drupal");
            Request sitemapRequest = Request.Get((String)(this.drupalLocation + "/sitemap.xml"));
            InputStream sitemapInputStream = this.executor.execute(sitemapRequest).returnContent().asStream();
            DrupalSitemapParser parser = new DrupalSitemapParser(sitemapInputStream, this.log);
            this.sitemapEntries = parser.getAllLocationsOfType(type);
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return this.sitemapEntries;
    }
}

