/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation.drupal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.wildfly.maven.plugins.quickstart.documentation.MetaData;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.DrupalCommunication;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.CodingResource;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.Product;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.Tag;

public class CodingResourceGenerator {
    private Log log;
    private DrupalCommunication drupalCommunication;

    public CodingResourceGenerator(DrupalCommunication drupalCommunication, Log log) {
        this.log = log;
        this.drupalCommunication = drupalCommunication;
    }

    public CodingResource createResource(Path codingResourceDir, String resourceType) {
        try {
            MetaData metaData = MetaData.parseReadme(codingResourceDir);
            Optional<Product> targetProduct = this.drupalCommunication.getProducts().stream().filter(product -> product.getShortName().equals(metaData.getTargetProduct())).findFirst();
            String path = null;
            path = targetProduct.map(product -> "/" + resourceType + "s/" + product.getMachineName() + "/" + codingResourceDir.getFileName()).orElseGet(() -> "/" + resourceType + "s/" + codingResourceDir.getFileName());
            FileInputStream file = new FileInputStream(codingResourceDir.resolve("README.html").toFile());
            Document doc = Jsoup.parse((InputStream)file, (String)"UTF-8", (String)"");
            Elements docContent = doc.select("h1 ~ *:not(p:first-of-type)");
            CodingResource newResource = new CodingResource(path, metaData.getName(), docContent.toString());
            newResource.addAuthor(metaData.getAuthor());
            newResource.addDescription(metaData.getSummary());
            newResource.addResourceType(resourceType);
            newResource.addLevel(metaData.getLevel());
            Arrays.stream(metaData.getTechnologies()).map(String::trim).forEach(newResource::addTechnologies);
            newResource.addSourceLink(metaData.getSource(), "");
            targetProduct.ifPresent(newResource::addRelatedProduct);
            List<Tag> tags = this.drupalCommunication.getTags().stream().filter(tag -> Arrays.asList(metaData.getTechnologies()).contains(tag.getName())).collect(Collectors.toList());
            tags.forEach(newResource::addTag);
            return newResource;
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
            return null;
        }
    }
}

