/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class MetaData {
    private final String name;
    private String author;
    private String level;
    private String summary;
    private String targetProduct;
    private String source;
    private String prerequisites;
    private String[] technologies;

    public static MetaData parseReadme(Path quickstartDir) throws IOException {
        Path path = quickstartDir.resolve("README.adoc");
        MetaData metaData = new MetaData(quickstartDir.getFileName().toString());
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            boolean shouldReadAbstract = false;
            while ((line = reader.readLine()) != null) {
                result.add(line);
                if (shouldReadAbstract) {
                    metaData.summary = line;
                    shouldReadAbstract = false;
                }
                if ("[abstract]".equals(line.trim())) {
                    shouldReadAbstract = true;
                    continue;
                }
                metaData.parseLine(line);
                if (result.size() > 15) break;
            }
        }
        return metaData;
    }

    private MetaData(String name) {
        this.name = name;
    }

    private void parseLine(String line) {
        if (line.toLowerCase(Locale.US).startsWith(":author:")) {
            this.author = line.substring(line.indexOf(": ") + 2).trim();
        } else if (line.toLowerCase(Locale.US).startsWith(":technologies:")) {
            this.technologies = line.substring(line.indexOf(": ") + 2).trim().split(",");
        } else if (line.toLowerCase(Locale.US).startsWith(":level:")) {
            this.level = line.substring(line.indexOf(": ") + 2).trim();
        } else if (line.startsWith(":productName:")) {
            this.targetProduct = line.substring(line.indexOf(": ") + 2).trim();
        } else if (line.toLowerCase(Locale.US).startsWith(":source:")) {
            this.source = line.substring(line.indexOf(": ") + 2).trim().replaceAll("<", "").replaceAll(">", "");
        } else if (line.toLowerCase(Locale.US).startsWith(":prerequisites:")) {
            this.prerequisites = line.substring(line.indexOf(": ") + 2).trim();
        }
    }

    String getTechnologiesAsString() {
        return Arrays.stream(this.technologies).map(String::trim).collect(Collectors.joining(", "));
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getTargetProduct() {
        return this.targetProduct;
    }

    public void setTargetProduct(String targetProduct) {
        this.targetProduct = targetProduct;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String[] getTechnologies() {
        return this.technologies;
    }

    public void setTechnologies(String[] technologies) {
        this.technologies = technologies;
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", author='" + this.author + '\'' + ", level='" + this.level + '\'' + ", summary='" + this.summary + '\'' + ", targetProduct='" + this.targetProduct + '\'' + ", source='" + this.source + '\'' + ", prerequisites='" + this.prerequisites + '\'' + ", technologies=" + Arrays.toString(this.technologies) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)o;
        return Objects.equals(this.getName(), metaData.getName()) && Objects.equals(this.getAuthor(), metaData.getAuthor()) && Objects.equals(this.getLevel(), metaData.getLevel()) && Objects.equals(this.getSummary(), metaData.getSummary()) && Objects.equals(this.getTargetProduct(), metaData.getTargetProduct()) && Objects.equals(this.getSource(), metaData.getSource()) && Objects.equals(this.getPrerequisites(), metaData.getPrerequisites()) && Arrays.equals(this.getTechnologies(), metaData.getTechnologies());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAuthor(), this.getLevel(), this.getSummary(), this.getTargetProduct(), this.getSource(), this.getPrerequisites(), this.getTechnologies());
    }
}

