/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TOCGenerator {
    private final List<String> ignoredDirs;

    public static void main(String[] args) throws IOException {
        Path root = Paths.get(".", new String[0]).normalize();
        new TOCGenerator(Arrays.asList("target", "dist", "template", "guide")).generate(root, "[TOC-quickstart]", Paths.get("target/docs/README.md", new String[0]));
    }

    public TOCGenerator(List<String> ignoredDirs) {
        this.ignoredDirs = ignoredDirs;
    }

    public void generate(Path root, String tocMarker, Path targetDoc) throws IOException {
        TreeSet<MetaData> allMetaData = new TreeSet<MetaData>(Comparator.comparing(o -> ((MetaData)o).name));
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(root, entry -> Files.isDirectory(entry, new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && !this.ignoredDirs.contains(entry.getFileName().toString()));){
            dirs.forEach(path -> {
                if (Files.exists(path.resolve("README.md"), new LinkOption[0])) {
                    try {
                        allMetaData.add(TOCGenerator.parseReadme(path));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println(String.format("Directory %s doesn't contain README.md, skipping", path));
                }
            });
        }
        StringBuffer sb = TOCGenerator.generateTOC(allMetaData);
        Path tocFile = root.resolve(targetDoc);
        String tocFileContent = new String(Files.readAllBytes(tocFile), StandardCharsets.UTF_8);
        tocFileContent = tocFileContent.replace(tocMarker, sb.toString());
        Files.write(tocFile, tocFileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static StringBuffer generateTOC(Set<MetaData> metaDataList) {
        StringBuffer sb = new StringBuffer();
        sb.append("| *Quickstart Name* | *Demonstrated Technologies* | *Description* | *Experience Level Required* | *Prerequisites* |\n");
        sb.append("| --- | --- | --- | --- | --- |\n");
        for (MetaData md : metaDataList) {
            sb.append("| ").append("[").append(md.name).append("]").append("(").append(md.name).append("/README.md) |").append(md.getTechnologiesAsString()).append(" | ").append(md.summary).append(" | ").append(md.level).append(" | ").append(md.prerequisites).append(" |").append("\n");
        }
        return sb;
    }

    private static MetaData parseReadme(Path quickstartDir) throws IOException {
        Path path = quickstartDir.resolve("README.md");
        MetaData metaData = new MetaData(quickstartDir.getFileName().toString());
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ArrayList<String> result = new ArrayList<String>();
            do {
                String line;
                if ((line = reader.readLine()) == null) {
                    break;
                }
                result.add(line);
                metaData.parseLine(line);
            } while (result.size() <= 10);
        }
        return metaData;
    }

    private static class MetaData {
        private final String name;
        private String author;
        private String level;
        private String summary;
        private String targetProduct;
        private String source;
        private String prerequisites = "";
        private String[] technologies = new String[0];

        private MetaData(String name) {
            this.name = name;
        }

        void parseLine(String line) {
            if (line.startsWith("Author")) {
                this.author = line.substring(line.indexOf(" ")).trim();
            } else if (line.startsWith("Technologies")) {
                this.technologies = line.substring(line.indexOf(" ")).trim().split(",");
            } else if (line.startsWith("Level")) {
                this.level = line.substring(line.indexOf(" ")).trim();
            } else if (line.startsWith("Summary")) {
                this.summary = line.substring(line.indexOf(" ")).trim();
            } else if (line.startsWith("Target Product")) {
                this.targetProduct = line.substring(line.indexOf(" ", 14)).trim();
            } else if (line.startsWith("source")) {
                this.source = line.substring(line.indexOf(" ")).trim();
            } else if (line.startsWith("Prerequisites")) {
                this.prerequisites = line.substring(line.indexOf(" ")).trim();
            }
        }

        String getTechnologiesAsString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.technologies.length; ++i) {
                sb.append(this.technologies[i].trim());
                if (i >= this.technologies.length - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public String toString() {
            return "{name='" + this.name + '\'' + ", author='" + this.author + '\'' + ", level='" + this.level + '\'' + ", summary='" + this.summary + '\'' + ", targetProduct='" + this.targetProduct + '\'' + ", source='" + this.source + '\'' + ", prerequisites='" + this.prerequisites + '\'' + ", technologies=" + Arrays.toString(this.technologies) + '}';
        }
    }
}

