/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mail.ra;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import org.wildfly.mail.ra.MailActivationSpec;
import org.wildfly.mail.ra.MailFolder;

public class POP3MailFolder
extends MailFolder {
    private boolean flush;

    public POP3MailFolder(MailActivationSpec spec) {
        super(spec);
        this.flush = spec.isFlush();
    }

    @Override
    protected Message[] getMessages(Folder folder) throws MessagingException {
        return folder.getMessages();
    }

    @Override
    protected Store openStore(Session session) throws NoSuchProviderException {
        return session.getStore("pop3");
    }

    @Override
    protected void markMessageSeen(Message message) throws MessagingException {
        message.setFlag(Flags.Flag.DELETED, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeStore(boolean success, Store store, Folder folder) throws MessagingException {
        try {
            if (folder != null && folder.isOpen()) {
                folder.close(success && this.flush);
            }
        }
        finally {
            if (store != null && store.isConnected()) {
                store.close();
            }
        }
    }
}

