/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mail.ra;

import java.lang.reflect.Method;
import javax.mail.Message;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import org.jboss.logging.Logger;
import org.wildfly.mail.ra.MailActivationSpec;
import org.wildfly.mail.ra.MailFolder;
import org.wildfly.mail.ra.MailListener;

public class MailActivation
implements Comparable,
Work {
    private static final Logger log = Logger.getLogger(MailActivation.class);
    public static final Method ON_MESSAGE;
    private boolean released;
    private long nextNewMsgCheckTime;
    protected MailActivationSpec spec;
    protected MessageEndpointFactory endpointFactory;

    public MailActivation(MessageEndpointFactory endpointFactory, MailActivationSpec spec) {
        this.endpointFactory = endpointFactory;
        this.spec = spec;
    }

    public long getNextNewMsgCheckTime() {
        return this.nextNewMsgCheckTime;
    }

    public void updateNextNewMsgCheckTime(long now) {
        this.nextNewMsgCheckTime = now + this.spec.getPollingInterval();
    }

    public int compareTo(Object obj) {
        MailActivation ma = (MailActivation)obj;
        return (int)(this.nextNewMsgCheckTime - ma.getNextNewMsgCheckTime());
    }

    public boolean isReleased() {
        return this.released;
    }

    public void release() {
        this.released = true;
        log.tracef("released", new Object[0]);
    }

    public void run() {
        this.released = false;
        log.tracef("Begin new msgs check", new Object[0]);
        try {
            MailFolder mailFolder = MailFolder.getInstance(this.spec);
            mailFolder.open();
            while (mailFolder.hasNext()) {
                Message msg = (Message)mailFolder.next();
                this.deliverMsg(msg);
            }
            mailFolder.close();
        }
        catch (Exception e) {
            log.error((Object)("Failed to execute folder check, spec=" + this.spec));
        }
        log.tracef("End new msgs check", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMsg(Message msg) {
        MessageEndpoint endpoint = null;
        try {
            endpoint = this.endpointFactory.createEndpoint(null);
            if (endpoint != null && endpoint instanceof MailListener) {
                log.tracef("deliverMsg: msg subject=", (Object)msg.getSubject());
                MailListener listener = (MailListener)endpoint;
                listener.onMessage(msg);
            }
        }
        catch (Throwable e) {
            log.debug((Object)"onMessage delivery failure", e);
        }
        finally {
            if (endpoint != null) {
                endpoint.release();
            }
        }
    }

    static {
        try {
            ON_MESSAGE = MailListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

