/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.core.launcher.CliCommandBuilder;

public class CliScriptRunner {
    public static void runCliScript(Path installHome, Path script, MessageWriter messageWriter) throws ProvisioningException {
        CliCommandBuilder builder = CliCommandBuilder.of((Path)installHome).addCliArgument("--no-operation-validation").addCliArgument("--echo-command").addCliArgument("--file=" + String.valueOf(script));
        List arguments = builder.build();
        messageWriter.verbose("Executing CLI process: %s", new Object[]{arguments.stream().collect(Collectors.joining(" "))});
        ProcessBuilder processBuilder = new ProcessBuilder(arguments).redirectErrorStream(true);
        processBuilder.environment().put("JBOSS_HOME", installHome.toString());
        CliScriptRunner.execute(processBuilder, messageWriter);
    }

    private static void execute(ProcessBuilder processBuilder, MessageWriter messageWriter) throws ProvisioningException {
        try {
            Process cliProcess = processBuilder.start();
            StringWriter errorWriter = new StringWriter();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(cliProcess.getInputStream(), StandardCharsets.UTF_8));
                 BufferedWriter writer = new BufferedWriter(errorWriter);){
                String line = reader.readLine();
                while (line != null) {
                    writer.write(line);
                    writer.newLine();
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                messageWriter.error((Throwable)e, (CharSequence)e.getMessage());
            }
            if (cliProcess.isAlive()) {
                try {
                    cliProcess.waitFor();
                }
                catch (InterruptedException e) {
                    messageWriter.error((Throwable)e, (CharSequence)e.getMessage());
                }
            }
            messageWriter.verbose("CLI output: %s", new Object[]{errorWriter.getBuffer().toString()});
            if (cliProcess.exitValue() != 0) {
                throw new ProvisioningException("Failed to execute finalize.cli script. CLI output is:" + errorWriter.getBuffer().toString());
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("CLI process failed", (Throwable)e);
        }
    }
}

