/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.xml.ConfigXmlWriter;
import org.wildfly.galleon.plugin.WfDiffPlugin;
import org.wildfly.galleon.plugin.config.generator.CompleteServerInvoker;
import org.wildfly.galleon.plugin.config.generator.ScriptRunner;

public class WfDiffConfigGenerator {
    private static final String CONFIGURE_SYNC = "/synchronization=simple:add(host=%s, port=%s, protocol=%s, username=%s, password=%s)";
    private static final String EXPORT_DIFF = "attachment save --overwrite --operation=/synchronization=simple:export-diff --file=";
    private static final String EXPORT_FEATURE = "attachment save --overwrite --operation=/synchronization=simple:feature-diff --file=";

    public static List<ConfigModel> exportDiff(ProvisioningRuntime runtime, Map<FeaturePackLocation.FPID, ConfigId> includedConfigs, Path customizedInstallation, Path target) throws ProvisioningException {
        List<ConfigModel> list;
        Path script;
        block7: {
            String host = runtime.getOptionValue(WfDiffPlugin.HOST);
            String port = runtime.getOptionValue(WfDiffPlugin.PORT);
            String protocol = runtime.getOptionValue(WfDiffPlugin.PROTOCOL);
            String username = runtime.getOptionValue(WfDiffPlugin.USERNAME);
            String password = runtime.getOptionValue(WfDiffPlugin.PASSWORD);
            String serverConfig = runtime.getOptionValue(WfDiffPlugin.SERVER_CONFIG);
            CompleteServerInvoker server = new CompleteServerInvoker(customizedInstallation.toAbsolutePath(), runtime.getMessageWriter(), serverConfig);
            script = null;
            try {
                Files.createDirectories(target, new FileAttribute[0]);
                script = WfDiffConfigGenerator.writeScript(runtime, "embed-server --admin-only --server-config=" + serverConfig, String.format(CONFIGURE_SYNC, host, port, protocol, username, password), EXPORT_DIFF + target.resolve("finalize.cli").toAbsolutePath(), EXPORT_FEATURE + target.resolve("feature_config.dmr").toAbsolutePath(), "stop-embedded-server");
                server.startServer();
                runtime.getMessageWriter().print((CharSequence)"Identifying config differences");
                ScriptRunner.runCliScript(runtime.getStagedDir(), script, runtime.getMessageWriter());
                runtime.getMessageWriter().print((CharSequence)"Identified config differences");
                server.stopServer();
                ConfigModel.Builder configBuilder = ((ConfigModel.Builder)ConfigModel.builder().setName("standalone.xml")).setModel("standalone");
                WfDiffConfigGenerator.createConfiguration(runtime, configBuilder, includedConfigs, target.resolve("feature_config.dmr").toAbsolutePath());
                ConfigModel config = configBuilder.build();
                ConfigXmlWriter.getInstance().write((Object)config, target.resolve("config.xml"));
                list = Collections.singletonList(config);
                if (!server.isServerActive()) break block7;
            }
            catch (IOException | XMLStreamException ex) {
                try {
                    runtime.getMessageWriter().error((Throwable)ex, "Couldn't compute the WildFly Model diff because of %s", new Object[]{ex.getMessage()});
                    throw new ProvisioningException("Couldn't compute the WildFly Model diff", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (server.isServerActive()) {
                        server.stopServer();
                    }
                    if (script != null) {
                        IoUtils.recursiveDelete(script);
                    }
                    throw throwable;
                }
            }
            server.stopServer();
        }
        if (script != null) {
            IoUtils.recursiveDelete((Path)script);
        }
        return list;
    }

    private static void createConfiguration(ProvisioningRuntime runtime, ConfigModel.Builder builder, Map<FeaturePackLocation.FPID, ConfigId> includedConfigBuilders, Path json) throws IOException, XMLStreamException, ProvisioningException {
        try (InputStream in = Files.newInputStream(json, new OpenOption[0]);){
            ModelNode featureDiff = ModelNode.fromBase64((InputStream)in);
            for (ModelNode feature : featureDiff.asList()) {
                String specName = feature.require("feature").require("spec").asString();
                DependencySpec dependencySpec = WfDiffConfigGenerator.getFeatureSpec(runtime, specName);
                FeatureSpec resolvedSpec = dependencySpec.spec;
                if (resolvedSpec == null || !resolvedSpec.hasAnnotations()) continue;
                HashMap<String, String> address = new HashMap<String, String>();
                for (Property elt : feature.require("feature").require("address").asPropertyList()) {
                    address.put(elt.getName(), elt.getValue().asString());
                }
                FeatureConfig featureConfig = FeatureConfig.newConfig((String)specName).setOrigin(dependencySpec.fpName);
                FeatureAnnotation firstAnnotation = (FeatureAnnotation)resolvedSpec.getAnnotations().iterator().next();
                WfDiffConfigGenerator.resolveAddressParams(featureConfig, address, firstAnnotation);
                HashMap<String, String> params = new HashMap<String, String>();
                if (feature.require("feature").hasDefined("params")) {
                    for (Property elt : feature.require("feature").require("params").asPropertyList()) {
                        params.put(elt.getName(), elt.getValue().asString());
                    }
                    WfDiffConfigGenerator.resolveParams(featureConfig, params, firstAnnotation);
                }
                if (feature.require("feature").require("exclude").asBoolean()) {
                    if (!includedConfigBuilders.containsKey(dependencySpec.fpid)) {
                        includedConfigBuilders.put(dependencySpec.fpid, new ConfigId("standalone", "standalone.xml"));
                    }
                    FeatureId.Builder idBuilder = FeatureId.builder((String)specName);
                    for (FeatureParameterSpec fparam : resolvedSpec.getIdParams()) {
                        idBuilder.setParam(fparam.getName(), featureConfig.getParam(fparam.getName()));
                    }
                    builder.excludeFeature(dependencySpec.fpName, idBuilder.build());
                    continue;
                }
                builder.addFeature(featureConfig);
            }
        }
    }

    private static DependencySpec getFeatureSpec(ProvisioningRuntime runtime, String name) throws ProvisioningException {
        ResolvedFeatureSpec spec;
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            spec = fp.getResolvedFeatureSpec(name);
            if (spec == null) continue;
            return new DependencySpec(FeaturePackConfig.getDefaultOriginName((FeaturePackLocation)fp.getSpec().getFPID().getLocation()), fp.getFPID(), spec.getSpec());
        }
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            spec = fp.getFeatureSpec(name);
            if (spec == null) continue;
            return new DependencySpec(FeaturePackConfig.getDefaultOriginName((FeaturePackLocation)fp.getSpec().getFPID().getLocation()), fp.getFPID(), (FeatureSpec)spec);
        }
        return null;
    }

    private static void resolveAddressParams(FeatureConfig featureConfig, Map<String, String> address, FeatureAnnotation annotation) {
        List addressParams = annotation.getElementAsList("addr-params");
        List addressParamMappings = annotation.getElementAsList("addr-params-mapping");
        if (addressParamMappings == null || addressParamMappings.isEmpty()) {
            addressParamMappings = addressParams;
        }
        for (int i = 0; i < addressParams.size(); ++i) {
            String value = address.get(addressParams.get(i));
            if (value != null) {
                if ("undefined".equals(value)) {
                    value = "GLN_UNDEFINED";
                }
            } else {
                value = "GLN_UNDEFINED";
            }
            featureConfig.putParam((String)addressParamMappings.get(i), value);
        }
    }

    private static void resolveParams(FeatureConfig featureConfig, Map<String, String> params, FeatureAnnotation annotation) {
        List addressParams = annotation.getElementAsList("op-params");
        List addressParamMappings = annotation.getElementAsList("op-params-mapping");
        if (addressParamMappings == null || addressParamMappings.isEmpty()) {
            addressParamMappings = addressParams;
        }
        for (int i = 0; i < addressParams.size(); ++i) {
            String value = params.get(addressParams.get(i));
            if (value == null) continue;
            featureConfig.putParam((String)addressParamMappings.get(i), value);
        }
    }

    private static Path writeScript(ProvisioningRuntime runtime, String ... commands) throws ProvisioningException {
        try {
            Path script = runtime.getTmpPath(new String[]{"diff-gen.cli"});
            if (!Files.exists(script.getParent(), new LinkOption[0])) {
                Files.createDirectories(script.getParent(), new FileAttribute[0]);
            }
            Files.write(script, Arrays.asList(commands), new OpenOption[0]);
            return script;
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to create a script", (Throwable)e);
        }
    }

    private static class DependencySpec {
        private final String fpName;
        private final FeaturePackLocation.FPID fpid;
        private final FeatureSpec spec;

        DependencySpec(String fpName, FeaturePackLocation.FPID fpid, FeatureSpec spec) {
            this.fpName = fpName;
            this.spec = spec;
            this.fpid = fpid;
        }
    }
}

