/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.wildfly.config.model.AddressTemplate;

public class GeneratorScope {
    private Map<AddressTemplate, JavaClassSource> generatedClasses = new HashMap<AddressTemplate, JavaClassSource>();
    private Map<AddressTemplate, Set<String>> singletons = new HashMap<AddressTemplate, Set<String>>();

    public void addGenerated(AddressTemplate address, JavaClassSource javaClass) {
        this.generatedClasses.put(address, javaClass);
    }

    public JavaClassSource getGenerated(AddressTemplate address) {
        assert (this.generatedClasses.containsKey(address)) : "Invalid key to generation target: " + address;
        return this.generatedClasses.get(address);
    }

    public void addSingleton(AddressTemplate address, Set<String> names) {
        this.singletons.put(address, names);
    }

    public Optional<Set<String>> getSingletonMetaData(AddressTemplate address) {
        Set<String> names = this.singletons.get(address);
        return names == null || names.isEmpty() ? Optional.empty() : Optional.of(names);
    }

    public boolean contains(String className) {
        boolean contains = false;
        for (Map.Entry<AddressTemplate, JavaClassSource> entry : this.generatedClasses.entrySet()) {
            if (!entry.getValue().getName().equals(className)) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

