/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.generator;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.wildfly.apigen.generator.ResourceMetaData;
import org.wildfly.apigen.model.AddressTemplate;
import org.wildfly.apigen.model.ResourceDescription;

public class MetaDataTraversal {
    private static final Logger log = Logger.getLogger(MetaDataTraversal.class.getName());
    private final LinkedList<ResourceMetaData> children;
    private final ResourceMetaData rootMetaData;

    public MetaDataTraversal(ResourceMetaData rootMetaData) {
        this.rootMetaData = rootMetaData;
        this.children = new LinkedList();
        this.dfs(rootMetaData.getAddress(), rootMetaData.getDescription(), (address, desc) -> {
            ResourceMetaData child = new ResourceMetaData(address, desc);
            child.setAllCfg(rootMetaData.getAllCfg());
            this.children.add(child);
        });
        Collections.sort(this.children);
    }

    private void dfs(AddressTemplate address, ResourceDescription root, Applicable applicable) {
        if (root == null) {
            return;
        }
        applicable.apply(address, root);
        if (root.hasChildrenDefined()) {
            Set<String> regularChildren = root.getChildrenTypes();
            for (String childType : regularChildren) {
                ResourceDescription childDescription = root.getChildDescription(childType, "*");
                AddressTemplate next = address.append(childType + "=*");
                this.dfs(next, childDescription, applicable);
            }
            Set<String> singletonChildren = root.getSingletonChildrenTypes();
            for (String childType : singletonChildren) {
                String[] tokens = childType.split("=");
                ResourceDescription childDescription = root.getChildDescription(tokens[0], tokens[1]);
                childDescription.setSingletonName(tokens[1]);
                AddressTemplate next = address.append(tokens[0] + "=" + tokens[1]);
                this.dfs(next, childDescription, applicable);
            }
        }
    }

    public Iterator<ResourceMetaData> createInstance() {
        return this.children.iterator();
    }

    public static interface Applicable {
        public void apply(AddressTemplate var1, ResourceDescription var2);
    }
}

