/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.logmanager.Level;
import org.wildfly.apigen.generator.Config;
import org.wildfly.apigen.generator.GeneratorScope;
import org.wildfly.apigen.generator.GeneratorTarget;
import org.wildfly.apigen.generator.MetaDataTraversal;
import org.wildfly.apigen.generator.ResourceMetaData;
import org.wildfly.apigen.generator.SourceFactory;
import org.wildfly.apigen.invocation.ClientFactory;
import org.wildfly.apigen.model.AddressTemplate;
import org.wildfly.apigen.model.DefaultStatementContext;
import org.wildfly.apigen.model.ResourceDescription;
import org.wildfly.apigen.operations.ReadDescription;

public class Generator {
    private static final Logger log = Logger.getLogger(Generator.class.getName());
    private static ModelControllerClient client;
    private DefaultStatementContext statementContext = new DefaultStatementContext();
    private final String targetDir;
    private final Config config;

    public Generator(String targetDir, Config config) {
        this.targetDir = targetDir;
        this.config = config;
        try {
            client = ClientFactory.createClient(config);
        }
        catch (Exception e) {
            log.log((java.util.logging.Level)Level.ERROR, "Failed to create model controller client", e);
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("Config: " + args[0]);
        log.info("Output: " + args[1]);
        try {
            Config config = Config.fromJson(args[0]);
            Generator generator = new Generator(args[1], config);
            generator.processGeneratorTargets();
            generator.shutdown();
        }
        catch (Throwable e) {
            System.exit(-1);
            log.log((java.util.logging.Level)Level.ERROR, "Unexpected error", e);
        }
    }

    public void deleteDir(String dir) throws Exception {
        Path directory = Paths.get(dir, new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void shutdown() {
        try {
            client.close();
        }
        catch (IOException e) {
            log.log((java.util.logging.Level)Level.ERROR, e.getMessage());
        }
    }

    public void processGeneratorTargets() {
        if (Files.exists(Paths.get(this.targetDir, new String[0]), new LinkOption[0])) {
            System.out.println("Delete output dir: " + this.targetDir);
            try {
                this.deleteDir(this.targetDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.config.getGeneratorTargets().forEach(target -> {
            try {
                GeneratorScope scope = new GeneratorScope();
                ResourceMetaData resourceMetaData = this.loadResourceMetaData((GeneratorTarget)target);
                resourceMetaData.set(ResourceMetaData.PKG, target.getTargetPackage());
                Iterator<ResourceMetaData> iterator = new MetaDataTraversal(resourceMetaData).createInstance();
                iterator.forEachRemaining(metaData -> this.generate(scope, (ResourceMetaData)metaData, this.targetDir));
            }
            catch (Exception e) {
                log.log((java.util.logging.Level)Level.ERROR, "Failed to process targets", e);
            }
        });
    }

    private ResourceMetaData loadResourceMetaData(GeneratorTarget generatorTarget) throws Exception {
        AddressTemplate address = generatorTarget.getSourceAddress();
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ArrayList<ModelNode> steps = new ArrayList<ModelNode>();
        Integer tokens = address.tokenLength();
        AddressTemplate parentAddress = address.subTemplate(0, tokens - 1);
        ModelNode childTypes = new ModelNode();
        childTypes.get("operation").set("read-children-types");
        childTypes.get("address").set((ModelNode)parentAddress.resolve(new DefaultStatementContext(), new String[0]));
        childTypes.get("include-singletons").set(true);
        steps.add(childTypes);
        ReadDescription rrd = new ReadDescription(address);
        steps.add(rrd.resolve(this.statementContext));
        composite.get("steps").set(steps);
        ModelNode response = client.execute(composite);
        boolean isSingleton = false;
        List types = response.get("result").get("step-1").get("result").asList();
        for (ModelNode type : types) {
            if (!type.asString().equals(address.getResourceType() + "=" + address.getResourceName())) continue;
            isSingleton = true;
            break;
        }
        ResourceDescription description = ResourceDescription.from(response.get("result").get("step-2"));
        if (isSingleton) {
            description.setSingletonName(address.getResourceName());
        }
        return new ResourceMetaData(generatorTarget.getSourceAddress(), description);
    }

    private void generate(GeneratorScope scope, ResourceMetaData resourceMetaData, String targetDir) {
        JavaClassSource javaClass = SourceFactory.createResourceAsClass(scope, resourceMetaData);
        if (!resourceMetaData.getDescription().getChildrenTypes().isEmpty()) {
            SourceFactory.createChildAccessors(scope, resourceMetaData, javaClass);
        }
        if (!resourceMetaData.getDescription().getSingletonChildrenTypes().isEmpty()) {
            SourceFactory.createSingletonChildAccessors(scope, resourceMetaData, javaClass);
        }
        this.writeClass(targetDir, javaClass);
        scope.addGenerated(resourceMetaData.getAddress(), javaClass);
    }

    private void writeClass(String targetDir, JavaClassSource javaClass) {
        try {
            targetDir = targetDir + File.separator + javaClass.getPackage().replace(".", File.separator);
            Files.createDirectories(Paths.get(targetDir, new String[0]), new FileAttribute[0]);
            Path fileName = Paths.get(targetDir + File.separator + javaClass.getName() + ".java", new String[0]);
            if (Files.exists(fileName, new LinkOption[0])) {
                throw new RuntimeException("File already exists, will be replaced: " + fileName);
            }
            Files.write(fileName, javaClass.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            log.log((java.util.logging.Level)Level.ERROR, "Failed to persist class", e);
        }
    }
}

