/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.catalina.Context;
import org.apache.catalina.valves.CrawlerSessionManagerValve;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.Session;

public class HttpSessionAdapter<B extends Batch>
extends ImmutableHttpSessionAdapter {
    private static final Set<String> EXCLUDED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("javax.security.auth.subject", "org.apache.catalina.realm.GSS_CREDENTIAL", CrawlerSessionManagerValve.class.getName())));
    private final Session<LocalSessionContext> session;
    private final CatalinaManager<B> manager;
    private final B batch;
    private final Runnable invalidateAction;

    public HttpSessionAdapter(Session<LocalSessionContext> session, CatalinaManager<B> manager, B batch, Runnable invalidateAction) {
        super(session, manager.getContext().getServletContext());
        this.session = session;
        this.manager = manager;
        this.batch = batch;
        this.invalidateAction = invalidateAction;
    }

    public boolean isNew() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            boolean bl = super.isNew();
            return bl;
        }
    }

    public long getCreationTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = super.getCreationTime();
            return l;
        }
    }

    public long getLastAccessedTime() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            long l = super.getLastAccessedTime();
            return l;
        }
    }

    public int getMaxInactiveInterval() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            int n = super.getMaxInactiveInterval();
            return n;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            this.session.getMetaData().setMaxInactiveInterval(interval > 0 ? Duration.ofSeconds(interval) : Duration.ZERO);
        }
    }

    public void invalidate() {
        this.invalidateAction.run();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            this.session.invalidate();
            this.batch.close();
        }
    }

    public Object getAttribute(String name) {
        if (EXCLUDED_ATTRIBUTES.contains(name)) {
            return ((LocalSessionContext)this.session.getLocalContext()).getNotes().get(name);
        }
        ((LocalSessionContext)this.session.getLocalContext()).getNotes().get(name);
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            Object object = super.getAttribute(name);
            return object;
        }
    }

    public Enumeration<String> getAttributeNames() {
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            Enumeration enumeration = super.getAttributeNames();
            return enumeration;
        }
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            if (EXCLUDED_ATTRIBUTES.contains(name)) {
                ((LocalSessionContext)this.session.getLocalContext()).getNotes().put(name, value);
            } else {
                Object old = null;
                try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
                    old = this.session.getAttributes().setAttribute(name, value);
                }
                if (old != value) {
                    this.notifySessionAttributeListeners(name, old, value);
                }
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        if (EXCLUDED_ATTRIBUTES.contains(name)) {
            ((LocalSessionContext)this.session.getLocalContext()).getNotes().remove(name);
        } else {
            Object value = null;
            try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
                value = this.session.getAttributes().removeAttribute(name);
            }
            if (value != null) {
                this.notifySessionAttributeListeners(name, value, null);
            }
        }
    }

    private void notifySessionAttributeListeners(String name, Object oldValue, Object newValue) {
        HttpSessionBindingListener listener;
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            try {
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        if (newValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)newValue;
            try {
                listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue != null ? oldValue : newValue);
        AttributeEventType type = oldValue == null ? AttributeEventType.ADDED : (newValue == null ? AttributeEventType.REMOVED : AttributeEventType.REPLACED);
        type.accept(this.manager.getContext(), event);
    }

    static enum AttributeEventType implements BiConsumer<Context, HttpSessionBindingEvent>
    {
        ADDED("beforeSessionAttributeAdded", "afterSessionAttributeAdded", (listener, event) -> listener.attributeAdded(event)),
        REMOVED("beforeSessionAttributeRemoved", "afterSessionAttributeRemoved", (listener, event) -> listener.attributeRemoved(event)),
        REPLACED("beforeSessionAttributeReplaced", "afterSessionAttributeReplaced", (listener, event) -> listener.attributeReplaced(event));

        private final String beforeEvent;
        private final String afterEvent;
        private final BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger;

        private AttributeEventType(String beforeEvent, String afterEvent, BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger) {
            this.beforeEvent = beforeEvent;
            this.afterEvent = afterEvent;
            this.trigger = trigger;
        }

        @Override
        public void accept(Context context, HttpSessionBindingEvent event) {
            Stream.of(context.getApplicationEventListeners()).filter(listener -> listener instanceof HttpSessionAttributeListener).map(listener -> (HttpSessionAttributeListener)listener).forEach(listener -> {
                try {
                    context.fireContainerEvent(this.beforeEvent, listener);
                    this.trigger.accept((HttpSessionAttributeListener)listener, event);
                }
                catch (Throwable e) {
                    context.getLogger().warn((Object)e.getMessage(), e);
                }
                finally {
                    context.fireContainerEvent(this.afterEvent, listener);
                }
            });
        }
    }
}

