/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.infinispan.annotation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.wildfly.clustering.web.spring.annotation.HttpSessionConfiguration;
import org.wildfly.clustering.web.spring.infinispan.InfinispanSessionRepository;
import org.wildfly.clustering.web.spring.infinispan.InfinispanSessionRepositoryConfiguration;
import org.wildfly.clustering.web.spring.infinispan.annotation.EnableInfinispanHttpSession;

@Configuration(proxyBeanMethods=false)
public class InfinispanHttpSessionConfiguration
extends HttpSessionConfiguration
implements InfinispanSessionRepositoryConfiguration {
    private String resource = "/WEB-INF/infinispan.xml";
    private String templateName = null;

    public InfinispanHttpSessionConfiguration() {
        super(EnableInfinispanHttpSession.class);
    }

    @Bean
    public InfinispanSessionRepository sessionRepository() {
        return new InfinispanSessionRepository(this);
    }

    @Override
    public String getConfigurationResource() {
        return this.resource;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Autowired(required=false)
    public void setConfigurationResource(String resource) {
        this.resource = resource;
    }

    @Autowired(required=false)
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void accept(AnnotationAttributes attributes) {
        super.accept(attributes);
        AnnotationAttributes config = attributes.getAnnotation("config");
        this.resource = config.getString("resource");
        String templateName = config.getString("template");
        this.templateName = !templateName.isEmpty() ? templateName : null;
    }
}

