/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.infinispan;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.jgroups.ChannelListener;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JChannelConfigurator
implements JGroupsChannelConfigurator {
    static final ByteBuffer UNKNOWN_FORK_RESPONSE = ByteBuffer.allocate(0);
    private final String name;
    private final ProtocolStackConfigurator configurator;

    public JChannelConfigurator(ServletContext context, TransportConfiguration transport) throws IOException {
        this.name = transport.stack();
        this.configurator = JChannelConfigurator.getProtocolStackConfigurator(context, transport);
    }

    private static ProtocolStackConfigurator getProtocolStackConfigurator(ServletContext context, TransportConfiguration transport) throws IOException {
        TypedProperties properties = transport.properties();
        if (properties.containsKey("channelConfigurator")) {
            return (JGroupsChannelConfigurator)properties.get("channelConfigurator");
        }
        if (properties.containsKey("configurationXml")) {
            String xml = properties.getProperty("configurationXml");
            try (ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));){
                XmlConfigurator xmlConfigurator = XmlConfigurator.getInstance((InputStream)input);
                return xmlConfigurator;
            }
        }
        String resource = properties.getProperty("configurationFile", "default-configs/default-jgroups-udp.xml");
        URL url = context.getClassLoader().getResource(resource);
        if (url == null) {
            url = context.getResource(resource);
        }
        if (url == null) {
            throw new FileNotFoundException(resource);
        }
        try (InputStream input = url.openStream();){
            XmlConfigurator xmlConfigurator = XmlConfigurator.getInstance((InputStream)input);
            return xmlConfigurator;
        }
    }

    public String getProtocolStackString() {
        return this.configurator.getProtocolStackString();
    }

    public List<ProtocolConfiguration> getProtocolStack() {
        return this.configurator.getProtocolStack();
    }

    public String getName() {
        return this.name;
    }

    public JChannel createChannel(String name) throws Exception {
        final FORK fork = new FORK();
        fork.setUnknownForkHandler(new UnknownForkHandler(){
            private final short id = ClassConfigurator.getProtocolId(RequestCorrelator.class);

            public Object handleUnknownForkStack(Message message, String forkStackId) {
                return this.handle(message);
            }

            public Object handleUnknownForkChannel(Message message, String forkChannelId) {
                return this.handle(message);
            }

            private Object handle(Message message) {
                RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(this.id);
                if (header != null && header.type == 0 && header.rspExpected()) {
                    Message response = message.makeReply().setFlag(message.getFlags()).clearFlag(new Message.Flag[]{Message.Flag.RSVP, Message.Flag.INTERNAL});
                    response.putHeader(FORK.ID, message.getHeader(FORK.ID));
                    response.putHeader(this.id, (Header)new RequestCorrelator.Header(1, header.req_id, header.corrId));
                    response.setBuffer(UNKNOWN_FORK_RESPONSE.array());
                    fork.getProtocolStack().getChannel().down(response);
                }
                return null;
            }
        });
        List<ProtocolConfiguration> configurations = this.getProtocolStack();
        ArrayList<Object> protocols = new ArrayList<Object>(configurations.size() + 1);
        final Properties properties = WildFlySecurityManager.getSystemPropertiesPrivileged();
        for (final ProtocolConfiguration configuration : configurations) {
            String protocolName = configuration.getProtocolName();
            final String className = protocolName.startsWith("org.jgroups.protocols.") ? protocolName : "org.jgroups.protocols." + protocolName;
            PrivilegedExceptionAction<Protocol> action = new PrivilegedExceptionAction<Protocol>(){

                @Override
                public Protocol run() throws Exception {
                    try {
                        Class<Protocol> protocolClass = Protocol.class.getClassLoader().loadClass(className).asSubclass(Protocol.class);
                        Protocol protocol = protocolClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        StringPropertyReplacer.replaceProperties((Map)configuration.getProperties(), (Properties)properties);
                        StackType type = Util.getIpStackType();
                        Configurator.initializeAttrs((Protocol)protocol, (ProtocolConfiguration)configuration, (StackType)type);
                        return protocol;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
            protocols.add((Protocol)WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)action));
        }
        protocols.add(fork);
        return new JChannel(protocols);
    }

    public void setSocketFactory(SocketFactory socketFactory) {
    }

    public void addChannelListener(ChannelListener listener) {
    }
}

