/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.spring.hotrod.annotation;

import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.web.context.ServletContextAware;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepository;
import org.wildfly.clustering.web.spring.hotrod.HotRodSessionRepositoryConfiguration;
import org.wildfly.common.Assert;

@Configuration(proxyBeanMethods=false)
public class HotRodHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements HotRodSessionRepositoryConfiguration,
ServletContextAware,
ApplicationEventPublisherAware,
BeanClassLoaderAware {
    private Properties properties;
    private Integer maxActiveSessions;
    private SessionAttributePersistenceStrategy persistenceStrategy;
    private String configurationName;
    private Supplier<String> identifierFactory = () -> UUID.randomUUID().toString();
    private ApplicationEventPublisher publisher;
    private ServletContext context;
    private ClassLoader loader;

    @Bean
    public HotRodSessionRepository sessionRepository() {
        Assert.assertNotNull((Object)this.properties);
        Assert.assertNotNull((Object)this.persistenceStrategy);
        Assert.assertNotNull((Object)this.publisher);
        Assert.assertNotNull((Object)this.context);
        Assert.assertNotNull((Object)this.loader);
        return new HotRodSessionRepository(this);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    @Override
    public Integer getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    @Override
    public SessionAttributePersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    @Override
    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    @Override
    public ApplicationEventPublisher getEventPublisher() {
        return this.publisher;
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void setServletContext(ServletContext context) {
        super.setServletContext(context);
        this.context = context;
    }

    public void setBeanClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Autowired(required=true)
    @Qualifier(value="hotRodProperties")
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Autowired(required=true)
    public void setPersistenceStrategy(SessionAttributePersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
    }

    @Autowired(required=false)
    public void setMaxActiveSessions(Integer maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }

    @Autowired(required=false)
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    @Autowired(required=false)
    public void setIdentifierFactory(Supplier<String> identifierFactory) {
        this.identifierFactory = identifierFactory;
    }
}

