/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.util.Map;
import java.util.function.BiFunction;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.scheduler.DecoratedSchedulerService;
import org.wildfly.clustering.server.scheduler.SchedulerService;

public class CacheEntrySchedulerService<I, K extends Key<I>, V, T>
extends DecoratedSchedulerService<I, T>
implements CacheEntryScheduler<K, V> {
    private final BiFunction<I, V, T> mapper;

    public CacheEntrySchedulerService(SchedulerService<I, T> scheduler, BiFunction<I, V, T> mapper) {
        super(scheduler);
        this.mapper = mapper;
    }

    @Override
    public void scheduleEntry(Map.Entry<K, V> entry) {
        Object id = ((Key)entry.getKey()).getId();
        this.schedule(id, this.mapper.apply(id, entry.getValue()));
    }

    @Override
    public void cancelKey(K key) {
        this.cancel(key.getId());
    }

    @Override
    public boolean containsKey(K key) {
        return this.contains(key.getId());
    }
}

