/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.IOException;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum AddressMarshaller implements FieldSetMarshaller.Simple<Address>
{
    INSTANCE;

    private static final int JGROUPS_ADDRESS_INDEX = 0;
    private static final int FIELDS = 1;

    public Address createInitialValue() {
        return LocalModeAddress.INSTANCE;
    }

    public int getFields() {
        return 1;
    }

    public Address readFrom(ProtoStreamReader reader, int index, WireType type, Address address) throws IOException {
        return switch (index) {
            case 0 -> (JGroupsAddress)reader.readObject(JGroupsAddress.class);
            default -> (Address)Supplier.call(() -> reader.skipField(type), null).thenApply((Function)org.wildfly.clustering.function.Function.of((Object)address)).get();
        };
    }

    public void writeTo(ProtoStreamWriter writer, Address address) throws IOException {
        if (address instanceof JGroupsAddress) {
            writer.writeObject(0, (Object)address);
        }
    }
}

