/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.expiration;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.infinispan.expiration.SimpleExpirationMetaData;

public enum SimpleExpirationMetaDataMarshaller implements ProtoStreamMarshaller<SimpleExpirationMetaData>
{
    INSTANCE;

    private static final int TIMEOUT_INDEX = 1;
    private static final int LAST_ACCESS_TIME_INDEX = 2;
    private static final Duration DEFAULT_TIMEOUT;
    private static final Instant DEFAULT_LAST_ACCESS_TIME;

    public Class<? extends SimpleExpirationMetaData> getJavaClass() {
        return SimpleExpirationMetaData.class;
    }

    public SimpleExpirationMetaData readFrom(ProtoStreamReader reader) throws IOException {
        Duration timeout = DEFAULT_TIMEOUT;
        Instant lastAccessTime = DEFAULT_LAST_ACCESS_TIME;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    timeout = (Duration)reader.readObject(Duration.class);
                    continue block4;
                }
                case 2: {
                    lastAccessTime = (Instant)reader.readObject(Instant.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new SimpleExpirationMetaData(timeout, lastAccessTime);
    }

    public void writeTo(ProtoStreamWriter writer, SimpleExpirationMetaData metaData) throws IOException {
        Instant lastAccessedTime;
        Duration timeout = metaData.getTimeout();
        if (!DEFAULT_TIMEOUT.equals(timeout)) {
            writer.writeObject(1, (Object)timeout);
        }
        if (!DEFAULT_LAST_ACCESS_TIME.equals(lastAccessedTime = metaData.getLastAccessTime())) {
            writer.writeObject(2, (Object)lastAccessedTime);
        }
    }

    static {
        DEFAULT_TIMEOUT = Duration.ofMinutes(30L);
        DEFAULT_LAST_ACCESS_TIME = Instant.EPOCH;
    }
}

