/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractShortArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Boolean2DArrayAssert;
import org.assertj.core.api.BooleanArrayAssert;
import org.assertj.core.api.Byte2DArrayAssert;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.Char2DArrayAssert;
import org.assertj.core.api.CharArrayAssert;
import org.assertj.core.api.Double2DArrayAssert;
import org.assertj.core.api.DoubleArrayAssert;
import org.assertj.core.api.Float2DArrayAssert;
import org.assertj.core.api.FloatArrayAssert;
import org.assertj.core.api.Int2DArrayAssert;
import org.assertj.core.api.IntArrayAssert;
import org.assertj.core.api.Long2DArrayAssert;
import org.assertj.core.api.LongArrayAssert;
import org.assertj.core.api.Short2DArrayAssert;
import org.assertj.core.api.ShortArrayAssert;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.test.TestInvocationHandler;

public abstract class AbstractLangTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractLangTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testUnmarshallable() {
        Tester<ThreadLocal<String>> tester = this.factory.createTester();
        tester.reject(ThreadLocal.withInitial(() -> "foo"));
    }

    @Test
    public void testBoolean() {
        this.factory.createTester().accept(true);
    }

    @Test
    public void testByte() {
        Tester<Byte> tester = this.factory.createTester();
        for (int i = 0; i < 8; ++i) {
            tester.accept(Integer.valueOf((1 << i) - 1).byteValue());
            tester.accept(Integer.valueOf(-1 << i).byteValue());
        }
    }

    @Test
    public void testShort() {
        Tester<Short> tester = this.factory.createTester();
        for (int i = 0; i < 16; ++i) {
            tester.accept(Integer.valueOf((1 << i) - 1).shortValue());
            tester.accept(Integer.valueOf(-1 << i).shortValue());
        }
    }

    @Test
    public void testInteger() {
        Tester<Integer> tester = this.factory.createTester();
        for (int i = 0; i < 32; ++i) {
            tester.accept((1 << i) - 1);
            tester.accept(-1 << i);
        }
    }

    @Test
    public void testLong() {
        Tester<Long> tester = this.factory.createTester();
        for (int i = 0; i < 64; ++i) {
            tester.accept((1L << i) - 1L);
            tester.accept(-1L << i);
        }
    }

    @Test
    public void testFloat() {
        Tester<Float> tester = this.factory.createTester();
        tester.accept(Float.valueOf(Float.NEGATIVE_INFINITY));
        tester.accept(Float.valueOf(Float.MIN_VALUE));
        tester.accept(Float.valueOf(0.0f));
        tester.accept(Float.valueOf(Float.MAX_VALUE));
        tester.accept(Float.valueOf(Float.POSITIVE_INFINITY));
        tester.accept(Float.valueOf(Float.NaN));
    }

    @Test
    public void testDouble() {
        Tester<Double> tester = this.factory.createTester();
        tester.accept(Double.NEGATIVE_INFINITY);
        tester.accept((Double)Double.MIN_VALUE);
        tester.accept(0.0);
        tester.accept((Double)Double.MAX_VALUE);
        tester.accept(Double.POSITIVE_INFINITY);
        tester.accept(Double.NaN);
    }

    @Test
    public void testCharacter() {
        Tester<Character> tester = this.factory.createTester();
        tester.accept(Character.valueOf('\u0000'));
        tester.accept(Character.valueOf('A'));
        tester.accept(Character.valueOf('\uffff'));
    }

    @Test
    public void testString() {
        Tester<String> tester = this.factory.createTester();
        tester.accept("A");
        tester.accept(UUID.randomUUID().toString());
    }

    @Test
    public void testBooleanArray() {
        boolean[] array = new boolean[]{true, false};
        this.factory.createTester(BooleanArrayAssert::new, AbstractBooleanArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Boolean2DArrayAssert::new, Boolean2DArrayAssert::isDeepEqualTo).accept(new boolean[][]{array, array});
        Boolean[] objectArray = new Boolean[]{true, false};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Boolean[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testByteArray() {
        byte[] array = new byte[]{-128, 0, 127};
        this.factory.createTester(ByteArrayAssert::new, AbstractByteArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Byte2DArrayAssert::new, Byte2DArrayAssert::isDeepEqualTo).accept(new byte[][]{array, array});
        Byte[] objectArray = new Byte[]{(byte)-128, (byte)0, (byte)127};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Byte[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testShortArray() {
        short[] array = new short[]{Short.MIN_VALUE, 0, Short.MAX_VALUE};
        this.factory.createTester(ShortArrayAssert::new, AbstractShortArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Short2DArrayAssert::new, Short2DArrayAssert::isDeepEqualTo).accept(new short[][]{array, array});
        Short[] objectArray = new Short[]{(short)Short.MIN_VALUE, (short)0, (short)Short.MAX_VALUE};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Short[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testIntegerArray() {
        int[] array = new int[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createTester(IntArrayAssert::new, AbstractIntArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Int2DArrayAssert::new, Int2DArrayAssert::isDeepEqualTo).accept(new int[][]{array, array});
        Integer[] objectArray = new Integer[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Integer[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createTester(LongArrayAssert::new, AbstractLongArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Long2DArrayAssert::new, Long2DArrayAssert::isDeepEqualTo).accept(new long[][]{array, array});
        Long[] objectArray = new Long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Long[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testFloatArray() {
        float[] array = new float[]{Float.MIN_VALUE, 0.0f, Float.MAX_VALUE};
        this.factory.createTester(FloatArrayAssert::new, AbstractFloatArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Float2DArrayAssert::new, Float2DArrayAssert::isDeepEqualTo).accept(new float[][]{array, array});
        Float[] objectArray = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Float[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testDoubleArray() {
        double[] array = new double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createTester(DoubleArrayAssert::new, AbstractDoubleArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Double2DArrayAssert::new, Double2DArrayAssert::isDeepEqualTo).accept(new double[][]{array, array});
        Double[] objectArray = new Double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Double[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testCharArray() {
        char[] array = new char[]{'\u0000', 'A', '\uffff'};
        this.factory.createTester(CharArrayAssert::new, AbstractCharArrayAssert::containsExactly).accept(array);
        this.factory.createTester(Char2DArrayAssert::new, Char2DArrayAssert::isDeepEqualTo).accept(new char[][]{array, array});
        Character[] objectArray = new Character[]{Character.valueOf('\u0000'), Character.valueOf('A'), Character.valueOf('\uffff')};
        this.factory.createArrayTester().accept(objectArray);
        this.factory.create2DArrayTester().accept(new Character[][]{objectArray, objectArray});
        this.factory.create2DArrayTester().accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testObjectArray() {
        String string1 = "foo";
        String string2 = "bar";
        String[] stringArray = new String[]{string1, string2};
        this.factory.createArrayTester().accept(stringArray);
        this.factory.createArrayTester().accept(new String[]{string1, string1});
        this.factory.create2DArrayTester().accept(new String[][]{stringArray, stringArray});
        this.factory.create2DArrayTester().accept(new Object[][]{stringArray, stringArray});
    }

    @Test
    public void testNull() {
        this.factory.createIdentityTester().accept(null);
    }

    @Test
    public void testClass() {
        Tester<Class> tester = this.factory.createIdentityTester();
        tester.accept(Object.class);
        tester.accept(Integer.class);
        tester.accept(Throwable.class);
        tester.accept(Exception.class);
    }

    @Test
    public void testException() {
        RuntimeException exception = new RuntimeException("foo");
        exception.setStackTrace(new StackTraceElement[]{exception.getStackTrace()[0]});
        Exception cause = new Exception("bar");
        cause.setStackTrace(new StackTraceElement[]{cause.getStackTrace()[0]});
        Error suppressed = new Error("baz");
        suppressed.setStackTrace(new StackTraceElement[]{suppressed.getStackTrace()[0]});
        exception.initCause(cause);
        exception.addSuppressed(suppressed);
        this.factory.createTester(AbstractLangTestCase::assertEquals).accept(exception);
    }

    @Test
    public void testStackTrace() {
        this.factory.createTester(AbstractLangTestCase::assertEquals).accept(new StackTraceElement("class", "method", "file", -1));
        this.factory.createTester(AbstractLangTestCase::assertEquals).accept(new StackTraceElement("loader", "module", "1.0", "class", "method", "file", 1));
    }

    @Test
    public void testProxy() {
        Object proxy = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Iterable.class}, (InvocationHandler)new TestInvocationHandler("foo"));
        this.factory.createTester(AbstractLangTestCase::assertProxyEquals).accept(proxy);
    }

    private static void assertProxyEquals(Object expected, Object actual) {
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((boolean)Proxy.isProxyClass(actual.getClass())).isTrue();
        Assertions.assertThat((Object)Proxy.getInvocationHandler(actual)).isInstanceOf(TestInvocationHandler.class);
        TestInvocationHandler actualHandler = (TestInvocationHandler)Proxy.getInvocationHandler(actual);
        TestInvocationHandler expectedHandler = (TestInvocationHandler)Proxy.getInvocationHandler(expected);
        Assertions.assertThat((Object)actualHandler.getValue()).isEqualTo(expectedHandler.getValue());
    }

    private static void assertEquals(Throwable expected, Throwable actual) {
        Assertions.assertThat((String)actual.getMessage()).isEqualTo(expected.getMessage());
        StackTraceElement[] expectedStackTrace = expected.getStackTrace();
        Object[] actualStackTrace = expected.getStackTrace();
        Assertions.assertThat((Object[])actualStackTrace).hasSameSizeAs((Object)expectedStackTrace);
        for (int i = 0; i < actualStackTrace.length; ++i) {
            AbstractLangTestCase.assertEquals(expectedStackTrace[i], (StackTraceElement)actualStackTrace[i]);
        }
        Throwable[] expectedSuppressed = expected.getSuppressed();
        Object[] actualSuppressed = actual.getSuppressed();
        Assertions.assertThat((Object[])actualSuppressed).hasSameSizeAs((Object)expectedSuppressed);
        for (int i = 0; i < actualSuppressed.length; ++i) {
            AbstractLangTestCase.assertEquals(expectedSuppressed[i], (Throwable)actualSuppressed[i]);
        }
        if (expected.getCause() != null) {
            Assertions.assertThat((Throwable)actual.getCause()).isNotNull();
            AbstractLangTestCase.assertEquals(expected.getCause(), actual.getCause());
        } else {
            Assertions.assertThat((Throwable)actual.getCause()).isNull();
        }
    }

    private static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        Assertions.assertThat((String)actual.getClassName()).isEqualTo(expected.getClassName());
        Assertions.assertThat((String)actual.getMethodName()).isEqualTo(expected.getMethodName());
        Assertions.assertThat((String)actual.getFileName()).isEqualTo(expected.getFileName());
        Assertions.assertThat((int)actual.getLineNumber()).isEqualTo(expected.getLineNumber());
        Assertions.assertThat((String)actual.getClassLoaderName()).isEqualTo(expected.getClassLoaderName());
        Assertions.assertThat((String)actual.getModuleName()).isEqualTo(expected.getModuleName());
        Assertions.assertThat((String)actual.getModuleVersion()).isEqualTo(expected.getModuleVersion());
    }
}

