/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.test.Person;

public abstract class AbstractCircularReferenceTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractCircularReferenceTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void test() {
        Person parent = Person.create("parent");
        Person self = Person.create("self");
        parent.addChild(self);
        parent.addChild(Person.create("sibling"));
        self.addChild(Person.create("son"));
        self.addChild(Person.create("daughter"));
        Tester<Person> tester = this.factory.createTester((expected, actual) -> {
            Assertions.assertThat((Comparable)actual).isEqualTo(expected);
            Assertions.assertThat((Comparable)actual.getParent()).isEqualTo((Object)expected.getParent());
            Assertions.assertThat(actual.getChildren()).isEqualTo(expected.getChildren());
            for (Person child : actual.getParent().getChildren()) {
                Assertions.assertThat((Comparable)child.getParent()).isSameAs((Object)actual.getParent());
            }
            for (Person child : actual.getChildren()) {
                Assertions.assertThat((Comparable)child.getParent()).isSameAs(actual);
            }
        });
        tester.accept(self);
    }
}

