/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.context.ContextualExecutor;

public interface Contextualizer {
    public static final Contextualizer NONE = new Contextualizer(){

        @Override
        public Runnable contextualize(Runnable runner) {
            return runner;
        }

        @Override
        public <T> Callable<T> contextualize(Callable<T> caller) {
            return caller;
        }

        @Override
        public <T> Supplier<T> contextualize(Supplier<T> supplier) {
            return supplier;
        }

        @Override
        public <V> Consumer<V> contextualize(Consumer<V> consumer) {
            return consumer;
        }

        @Override
        public <V1, V2> BiConsumer<V1, V2> contextualize(BiConsumer<V1, V2> consumer) {
            return consumer;
        }

        @Override
        public <V, R> Function<V, R> contextualize(Function<V, R> function) {
            return function;
        }

        @Override
        public <V1, V2, R> BiFunction<V1, V2, R> contextualize(BiFunction<V1, V2, R> function) {
            return function;
        }
    };

    public Runnable contextualize(Runnable var1);

    public <T> Callable<T> contextualize(Callable<T> var1);

    public <T> Supplier<T> contextualize(Supplier<T> var1);

    public <V> Consumer<V> contextualize(Consumer<V> var1);

    public <V1, V2> BiConsumer<V1, V2> contextualize(BiConsumer<V1, V2> var1);

    public <V, R> Function<V, R> contextualize(Function<V, R> var1);

    public <V1, V2, R> BiFunction<V1, V2, R> contextualize(BiFunction<V1, V2, R> var1);

    public static <C> Contextualizer withContextProvider(Supplier<Context<C>> provider) {
        final ContextualExecutor executor = ContextualExecutor.withContextProvider(provider);
        return new Contextualizer(){

            @Override
            public Runnable contextualize(final Runnable runner) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executor.execute(runner);
                    }
                };
            }

            @Override
            public <T> Callable<T> contextualize(final Callable<T> caller) {
                return new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return executor.execute(caller);
                    }
                };
            }

            @Override
            public <T> Supplier<T> contextualize(final Supplier<T> supplier) {
                return new Supplier<T>(){

                    @Override
                    public T get() {
                        return executor.execute(supplier);
                    }
                };
            }

            @Override
            public <V> Consumer<V> contextualize(final Consumer<V> consumer) {
                return new Consumer<V>(){

                    @Override
                    public void accept(V value) {
                        executor.execute(consumer, value);
                    }
                };
            }

            @Override
            public <V1, V2> BiConsumer<V1, V2> contextualize(final BiConsumer<V1, V2> consumer) {
                return new BiConsumer<V1, V2>(){

                    @Override
                    public void accept(V1 value1, V2 value2) {
                        executor.execute(consumer, value1, value2);
                    }
                };
            }

            @Override
            public <V, R> Function<V, R> contextualize(final Function<V, R> function) {
                return new Function<V, R>(){

                    @Override
                    public R apply(V value) {
                        return executor.execute(function, value);
                    }
                };
            }

            @Override
            public <V1, V2, R> BiFunction<V1, V2, R> contextualize(final BiFunction<V1, V2, R> function) {
                return new BiFunction<V1, V2, R>(){

                    @Override
                    public R apply(V1 value1, V2 value2) {
                        return executor.execute(function, value1, value2);
                    }
                };
            }
        };
    }

    public static Contextualizer composite(final Iterable<Contextualizer> contextualizers) {
        return new Contextualizer(){

            @Override
            public Runnable contextualize(Runnable runner) {
                Runnable result = runner;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <T> Callable<T> contextualize(Callable<T> caller) {
                Callable<T> result = caller;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <T> Supplier<T> contextualize(Supplier<T> supplier) {
                Supplier<T> result = supplier;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V> Consumer<V> contextualize(Consumer<V> consumer) {
                Consumer<V> result = consumer;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V1, V2> BiConsumer<V1, V2> contextualize(BiConsumer<V1, V2> consumer) {
                BiConsumer<V1, V2> result = consumer;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V, R> Function<V, R> contextualize(Function<V, R> function) {
                Function<V, R> result = function;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V1, V2, R> BiFunction<V1, V2, R> contextualize(BiFunction<V1, V2, R> function) {
                BiFunction<V1, V2, R> result = function;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }
        };
    }
}

