/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.function.Consumer;

public interface ContextualExecutor
extends Executor {
    public <V> void execute(java.util.function.Consumer<V> var1, V var2);

    public <V1, V2> void execute(BiConsumer<V1, V2> var1, V1 var2, V2 var3);

    default public <T> T execute(Callable<T> caller) throws Exception {
        try {
            return this.execute((Supplier<T>)org.wildfly.clustering.function.Supplier.call(caller, (Function)Consumer.throwing(CompletionException::new).thenReturn((Supplier)org.wildfly.clustering.function.Supplier.empty())));
        }
        catch (CompletionException e) {
            throw (Exception)e.getCause();
        }
    }

    public <T> T execute(Supplier<T> var1);

    public <V, R> R execute(Function<V, R> var1, V var2);

    public <V1, V2, R> R execute(BiFunction<V1, V2, R> var1, V1 var2, V2 var3);

    public static <C> ContextualExecutor withContextProvider(final Supplier<Context<C>> provider) {
        return new ContextualExecutor(){

            @Override
            public void execute(Runnable runner) {
                try (Context context = (Context)provider.get();){
                    runner.run();
                }
            }

            @Override
            public <V> void execute(java.util.function.Consumer<V> consumer, V value) {
                try (Context context = (Context)provider.get();){
                    consumer.accept(value);
                }
            }

            @Override
            public <V1, V2> void execute(BiConsumer<V1, V2> consumer, V1 value1, V2 value2) {
                try (Context context = (Context)provider.get();){
                    consumer.accept(value1, value2);
                }
            }

            @Override
            public <T> T execute(Supplier<T> supplier) {
                try (Context context = (Context)provider.get();){
                    T t = supplier.get();
                    return t;
                }
            }

            @Override
            public <V, R> R execute(Function<V, R> function, V value) {
                try (Context context = (Context)provider.get();){
                    R r = function.apply(value);
                    return r;
                }
            }

            @Override
            public <V1, V2, R> R execute(BiFunction<V1, V2, R> function, V1 value1, V2 value2) {
                try (Context context = (Context)provider.get();){
                    R r = function.apply(value1, value2);
                    return r;
                }
            }
        };
    }
}

